<?php
    require_once 'function.php';
    //检验登录状态
    if(!ADMIN_LOGIN) {
        header('location:./login.php');
    }
    $DATA = Data::getInstance(true);
    $DAO = $DATA->getDao();
    $countApply = $DATA->getCount(TABLE_APPLY);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <title><?php echo $title; ?> - 管理中心</title>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width,height=device-height,initial-scale=1.0,minimum-scale=1,maximum-scale=1,user-scalable=no"/>
  <link rel="shortcut icon" type="images/x-icon" href="../favicon.ico"/>
  <link rel="stylesheet" type="text/css" href="../assets/css/font-awesome-4.7.0/css/font-awesome.css"/>
  <link rel="stylesheet" type="text/css" href="../assets/css/ozui.min.css"/>
  <link rel="stylesheet" type="text/css" href="style/css/main.css"/>
</head>

<body>
<div id="loadTable">
  <header class="oz-header">
    <div class="oz-nav-logo"><a href="index.php"><img src="style/images/logo.png" alt="logo"></a></div>
    <div class="oz-nav-bar">
      <span></span>
      <span></span>
      <span></span>
    </div>
    <div class="oz-nav-time" id="oz-nav-time"></div>
    <div class="oz-nav-search">
      <form action="site.php" method="get" id="search">
        <label>
          <select name="type" class="search-type" onchange="changeSearchType(this)">
            <option value="site">站点</option>
            <option value="post">文章</option>
          </select>
        </label>
        <label>
          <input type="text" class="oz-search-field" name="keyword" placeholder="请输入关键词..." required>
        </label>
        <button type="submit" class="oz-search-btn"><i class="fa fa-search fa-fw"></i></button>
      </form>
    </div>
    <div class="oz-nav-tool">
      <a href="javascript:" class="oz-tool-item" id="oz-nav-search"><i class="fa fa-search fa-fw"></i></a>
      <a href="../" class="oz-tool-item" target="_blank"><i class="fa fa-home fa-fw"></i></a>
      <a href="apply.php" class="oz-tool-item"><i class="fa fa-plus-square fa-fw"></i>
          <?php if(!empty($countApply)) { ?>
            <span class="oz-badge oz-bg-orange oz-badge-radius"><?php echo $countApply; ?></span>
          <?php } ?>
      </a>
      <a href="javascript:logout()" class="oz-tool-item"><i class="fa fa-power-off fa-fw"></i></a>
    </div>
    <a href="user.php" class="oz-nav-user"><img src="https://q2.qlogo.cn/headimg_dl?dst_uin=<?php echo $USER['qq']; ?>&spec=100" alt="qq"></a>
  </header>

  <nav class="oz-sidenav">
    <ul>
      <li><a href="index.php"><i class="fa fa-home fa-fw"></i> 后台首页</a></li>
      <li class="oz-nav-item">
        <a href="javascript:"><i class="fa fa-cube fa-fw"></i> 站点管理
            <?php if(!empty($countApply)) { ?>
              <span class="oz-dot oz-bg-orange"></span>
            <?php } ?>
          <span class="oz-drop-icon fa fa-angle-right fa-fw"></span>
        </a>
        <ul>
          <li><a href="sort.php?type=1">站点分类</a></li>
          <li><a href="site.php">站点列表</a></li>
          <li>
            <a href="apply.php">站点申请
                <?php if(!empty($countApply)) { ?>
                  <span class="oz-dot oz-bg-orange"></span>
                <?php } ?>
            </a>
          </li>
        </ul>
      </li>
      <li class="oz-nav-item">
        <a href="javascript:"><i class="fa fa-book fa-fw"></i> 文章管理<span class="oz-drop-icon fa fa-angle-right fa-fw"></span></a>
        <ul>
          <li><a href="sort.php?type=2">文章分类</a></li>
          <li><a href="post.php">文章列表</a></li>
        </ul>
      </li>
      <li class="oz-nav-item">
        <a href="javascript:"><i class="fa fa-gift fa-fw"></i> 相关管理<span class="oz-drop-icon fa fa-angle-right fa-fw"></span></a>
        <ul>
          <li><a href="notice.php">公告管理</a></li>
          <li><a href="user.php">用户管理</a></li>
          <li><a href="page.php">单页管理</a></li>
          <li><a href="link.php">友链管理</a></li>
          <li><a href="ad.php">广告管理</a></li>
        </ul>
      </li>
      <li class="oz-nav-item">
        <a href="javascript:"><i class="fa fa-cog fa-fw"></i> 系统管理<span class="oz-drop-icon fa fa-angle-right fa-fw"></span></a>
        <ul>
          <li><a href="config.php">网站设置</a></li>
          <li><a href="nav.php">系统导航</a></li>
          <li><a href="template.php">前台模板</a></li>
          <li><a href="image.php">通用图片</a></li>
          <li><a href="clear.php">垃圾清理</a></li>
        </ul>
      </li>
      <li class="oz-nav-item">
        <a href="javascript:"><i class="fa fa-gavel fa-fw"></i> 实用工具<span class="oz-drop-icon fa fa-angle-right fa-fw"></span></a>
        <ul>
          <li><a href="push.php">链接推送</a></li>
          <li><a href="email.php">邮箱发信</a></li>
        </ul>
      </li>
      <li class="oz-nav-item">
        <a href="javascript:"><i class="fa fa-flask fa-fw"></i> 备份恢复<span class="oz-drop-icon fa fa-angle-right fa-fw"></span></a>
        <ul>
          <li><a href="data.php">数据管理</a></li>
          <li><a href="source.php">源码管理</a></li>
        </ul>
      </li>
    </ul>
  </nav>