<?php
    $title = '在线商店';
    require_once 'header.php';
    $storeData = 'store.json';
    $templates = json_decode(@file_get_contents($storeData), 320);
    $countTemplate = @count($templates);
    $pageSize = !empty($_GET['size']) ? $_GET['size'] : 10;
    $nowPage = !empty($_GET['page']) ? $_GET['page'] : 1;
    $startNum = ($nowPage - 1) * $pageSize;
?>

  <div class="oz-container">
    <div class="oz-panel">
      <div class="oz-panel-head"><strong>模板商店</strong></div>
      <div class="oz-panel-body">
        <div class="oz-quote">
          共 <strong><?php echo $countTemplate; ?></strong> 个模板
          <button type="button" class="oz-btn oz-btn-sm oz-bg-orange" onclick="refreshStore()">刷新数据</button>
        </div>
          <?php for($i = $startNum; $i < $startNum + $pageSize && $i < $countTemplate; $i++) { ?>
            <div class="oz-xs-12 oz-sm-6 oz-md-4 oz-lg-3">
              <div class="template oz-tooltip oz-tooltip-up" oz-title="点击安装" onclick="downTemplate('<?php echo $templates[$i]['url'] ?>')">
                <div class="preview">
                  <img class="lazy-load" src="<?php echo IMAGES_URL; ?>loading.gif" data-src="<?php echo $templates[$i]['preview']; ?>" alt="">
                  <div class="more">
                    <p>版本：<?php echo $templates[$i]['version']; ?></p>
                    <p>作者：
                      <a href="<?php echo $templates[$i]['authorUrl']; ?>" target="_blank" class="oz-tooltip oz-tooltip-up" oz-title="<?php echo $templates[$i]['authorUrl']; ?>" onclick="event.stopPropagation()">
                          <?php echo $templates[$i]['author']; ?>
                      </a>
                    </p>
                    <p>介绍：<?php echo $templates[$i]['description']; ?></p>
                    <p>时间：<?php echo $templates[$i]['time']; ?></p>
                  </div>
                </div>
                <div class="name"><?php echo $templates[$i]['name']; ?></div>
              </div>
            </div>
          <?php } ?>
          <?php echo paging($countTemplate, $nowPage, $pageSize); ?>
      </div>
    </div>
  </div>

<?php
    require_once 'footer.php';
?>