<?php
    $title = '前台模板';
    require_once 'header.php';
    $templates = getTemplates();
    $countTemplate = count($templates);
?>

  <div class="oz-container">
    <div class="oz-xs-12 oz-lg-8">
      <div class="oz-panel">
        <div class="oz-panel-head"><strong>模板列表</strong></div>
        <div class="oz-panel-body">
          <div class="oz-quote">
            共 <strong><?php echo $countTemplate; ?></strong> 个模板
            <a href="store.php" class="oz-btn oz-btn-sm oz-bg-orange">模板商店</a>
              <?php if(!checkTemplate(TEMPLATE_NAME)) {
                  echo '<strong>当前使用模板已损坏，请切换其他模板</strong>';
              } ?>
          </div>
            <?php foreach($templates as $template) {
                $using = TEMPLATE_NAME == $template['file'];
                ?>
              <div class="oz-xs-12 oz-sm-6 oz-md-4">
                <div class="template <?php echo $using ? 'active' : ''; ?>">
                  <div <?php if(!$using) {
                      echo 'onclick="changeTemplate(\'' . $template['file'] . '\')"';
                  } ?>>
                    <div class="preview">
                      <img src="<?php echo TL_URL . $template['file']; ?>/preview.jpg" alt="模板预览图">
                      <div class="more">
                        <p>版本：<?php echo $template['version']; ?></p>
                        <p>作者：<?php echo $template['author']; ?></p>
                        <p>介绍：<?php echo $template['description']; ?></p>
                      </div>
                    </div>
                    <div class="name"><?php echo $template['name']; ?></div>
                  </div>
                    <?php if(!$using) { ?>
                      <span class="delete fa fa-close fa-fw" onclick="deleteOne('template', '<?php echo $template['file']; ?>')"></span>
                      <a href="<?php echo OZDAO_URL . '?template=' . $template['file'] ?>" target="_blank" class="oz-btn oz-btn-sm oz-bg-orange template-btn">预览</a>
                      <!--                    <?php /*} else { */ ?>
                      <span class="oz-btn oz-btn-sm oz-bg-black template-btn" onclick="templateSetting('<?php /*echo $template['name']; */ ?>')">设置</span>-->
                    <?php } ?>
                </div>
              </div>
            <?php } ?>
        </div>
      </div>
    </div>
    <div class="oz-xs-12 oz-lg-4">
      <div class="oz-panel">
        <div class="oz-panel-head"><strong>安装模板</strong></div>
        <div class="oz-panel-body">
          <div class="oz-quote">上传一个zip压缩格式的OZDAO模板安装包</div>
          <form method="post" onsubmit="return false">
            <div class="oz-upload">
              <label class="oz-btn oz-bg-orange" onchange="selectFile(this, 'zip')">
                <input type="file" name="template" id="template">
                <i class="fa fa-folder-open fa-fw"></i> 选择
              </label>
              <span class="file-name">请选择文件</span>
            </div>
            <div class="oz-center">
              <button type="submit" class="oz-btn oz-bg-blue" style="width: 50%;" onclick="uploadFile('template')">安装</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <!--<div class="popup" id="setting-popup">
    <div class="oz-quote">
      温馨提示：序号用于排序[数字越小排名越前]。友情链接根据各个模板自定显示位置。
    </div>
    <form id="config-edit" method="post" onsubmit="return false">
      <label for="">
        <input type="text" name="template" value="<?php /*echo TEMPLATE_NAME; */ ?>" hidden>
      </label>
        <?php
      /*            $tSettings = getInitTSettings(false);
                  foreach($tSettings as $tSetting) { */ ?>
              <div class="oz-form-group">
                <span class="oz-form-label"><?php /*echo $tSetting['name']; */ ?></span>
                <label class="oz-form-field oz-tooltip oz-tooltip-up" oz-title="<?php /*echo $tSetting['description']; */ ?>">
                  <input type="text" placeholder="请输入<?php /*echo $tSetting['name']; */ ?>" name="<?php /*echo $tSetting['key']; */ ?>" value="<?php /*echo $tSetting['default']; */ ?>">
                </label>
              </div>
            <?php /*} */ ?>
      <div class="oz-center">
        <button type="submit" class="oz-btn oz-bg-blue" style="width: 50%;" onclick="editConfig()">保存</button>
      </div>
    </form>
  </div>-->

<?php
    require_once 'footer.php';
?>