<?php
    require_once 'init.php';

    header("Content-type: text/xml");
    header('HTTP/1.1 200 OK');

    echo '<?xml version="1.0" encoding="UTF-8"?>';
    $DATA = Data::getInstance();
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:mobile="http://www.baidu.com/schemas/sitemap-mobile/1/">
  <url>
    <loc><?php echo URWEB_URL; ?></loc>
    <mobile:mobile type="mobile"/>
    <lastmod><?php echo gmdate('Y-m-d\TH:i:s+00:00', time()); ?></lastmod>
    <changefreq>daily</changefreq>
    <priority>1.0</priority>
  </url>
    <?php
        //最新站点100个
        $sites = $DATA->getLatestSites(100);
        foreach($sites as $site) { ?>
          <url>
            <loc><?php echo $site['detail']; ?></loc>
            <mobile:mobile type="autoadapt"/>
            <lastmod><?php echo gmdate('Y-m-d\TH:i:s+00:00', time()); ?></lastmod>
            <changefreq>monthly</changefreq>
            <priority>0.8</priority>
          </url>
        <?php }
    ?>
    <?php
        //最新文章100篇
        $posts = $DATA->getLatestPosts(100);
        foreach($posts as $post) { ?>
          <url>
            <loc><?php echo $post['url']; ?></loc>
            <mobile:mobile type="autoadapt"/>
            <lastmod><?php echo gmdate('Y-m-d\TH:i:s+00:00', time()); ?></lastmod>
            <changefreq>monthly</changefreq>
            <priority>0.8</priority>
          </url>
        <?php }
    ?>
    <?php
        //站点分类
        $siteSorts = $DATA->getSiteSorts();
        foreach($siteSorts as $siteSort) { ?>
          <url>
            <loc><?php echo $siteSort['url']; ?></loc>
            <mobile:mobile type="autoadapt"/>
            <lastmod><?php echo gmdate('Y-m-d\TH:i:s+00:00', time()); ?></lastmod>
            <changefreq>monthly</changefreq>
            <priority>0.6</priority>
          </url>
        <?php }
    ?>
    <?php
        //文章分类
        $postSorts = $DATA->getPostSorts();
        foreach($postSorts as $postSort) { ?>
          <url>
            <loc><?php echo $postSort['url']; ?></loc>
            <mobile:mobile type="autoadapt"/>
            <lastmod><?php echo gmdate('Y-m-d\TH:i:s+00:00', time()); ?></lastmod>
            <changefreq>monthly</changefreq>
            <priority>0.6</priority>
          </url>
        <?php }
    ?>
</urlset>
