<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(-1);
header('Content-type:text/html; Charset=utf-8');
require '../mysql.class.php';
require '../config.php';
$url = file_get_contents("php://input");
$data_array = json_decode($url, true);

$mchid = $aliconfig['mchid'];
$appid = $aliconfig['appid'];
$notifyUrl = $aliconfig['notifyUrl'];
$rsaPrivateKey = $aliconfig['rsaPrivateKey']; //私钥
$alipayPublicKey = $aliconfig['alipayPublicKey']; //公钥

$type_txt = $data_array['type'];
switch ($type_txt) {
    case 'barcode':
        require './barcode.php';
        $outTradeNo = $data_array['outTradeNo']; //你自己的商品订单号，不能重复
        $payAmount = $data_array['payAmount']; //付款金额，单位:元
        $orderName = $data_array['orderName']; //订单标题
        $authCode = $data_array['authCode']; //用户付款码（商户使用设备扫码用户的付款条码读取到的条码数字，或 打开微信-》我-》钱包-》收付款 点击可查看付款码数字）
        $signType = 'RSA2';       //签名算法类型，支持RSA2和RSA，推荐使用RSA2
        if ($outTradeNo == '') {
            $outTradeNo = uniqid();
        }
        if ($orderName == '') {
            $orderName = $storename;
        }
        $sql = "insert into payorders (orgid,storeid,storename,paytype,mchid,orderno,ordername,amount,status,addtime) values ('$orgid','$storeid','$storename','alipay','$mchid','$outTradeNo','$orderName','$payAmount','待支付',now())";
        if ($db->query($sql)) {
            $aliPay = new AlipayService();
            $aliPay->setAppid($appid);
            $aliPay->setNotifyUrl($notifyUrl);
            $aliPay->setRsaPrivateKey($rsaPrivateKey);
            $aliPay->setTotalFee($payAmount);
            $aliPay->setOutTradeNo($outTradeNo);
            $aliPay->setOrderName($orderName);
            $aliPay->setAuthCode($authCode);
            $result = $aliPay->doPay();
            $result = $result['alipay_trade_pay_response'];
            $sql = "insert into logs (orderno,result) values ('$outTradeNo','" . json_encode($result) . "')";
            $db->query($sql);
            $arr = array();
            if ($result['code'] == '10000' && $result['msg'] == 'Success') {
                $trade_no = $result['trade_no'];
                $arr['return_code'] = 'SUCCESS';
                $arr['result_code'] = 'SUCCESS';
                $arr['cash_fee'] = bcmul($result['buyer_pay_amount'], 100);
                $sql = "update payorders set transactionid='$trade_no',status = '支付成功',paytime = now(),result = '" . json_encode($result) . "' where paytype ='alipay' and orgid = '$orgid' and orderno = '$outTradeNo'";
                $db->query($sql);
            } elseif ($result['code'] == '10003') {
                $arr['return_code'] = 'SUCCESS';
                $arr['result_code'] = 'FAIL';
                $arr['err_code'] = 'USERPAYING';
            } else {
                $arr['return_code'] = 'SUCCESS';
                $arr['result_code'] = 'FAIL';
                $arr['err_code'] = $result['msg'];
                $arr['err_code_des'] = $result['sub_msg'];
            }
        }

        $return = array(
            'outTradeNo' => $outTradeNo,
            'data' => $arr
        );

        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    case 'getqrcode':
        require './qrcode.php';
        $outTradeNo = $data_array['outTradeNo']; //你自己的商品订单号
        $payAmount = $data_array['payAmount']; //付款金额，单位:元
        $orderName = $data_array['orderName']; //订单标题
        if ($outTradeNo == '') {
            $outTradeNo = uniqid();
        }
        if ($orderName == '') {
            $orderName = $storename;
        }
        $sql = "insert into payorders (orgid,storeid,storename,paytype,mchid,orderno,ordername,amount,status,addtime) values ('$orgid','$storeid','$storename','alipay','$mchid','$outTradeNo','$orderName','$payAmount','待支付',now())";
        if ($db->query($sql)) {
            $aliPay = new AlipayService();
            $aliPay->setAppid($appid);
            $aliPay->setNotifyUrl($notifyUrl);
            $aliPay->setRsaPrivateKey($rsaPrivateKey);
            $aliPay->setTotalFee($payAmount);
            $aliPay->setOutTradeNo($outTradeNo);
            $aliPay->setOrderName($orderName);
            $result = $aliPay->doPay();
            $result = $result['alipay_trade_precreate_response'];
            if ($result['code'] == '10000') {
                //生成二维码
                $url = getqrcode($result['qr_code']);
            } else {
                $url = $result['msg'] . ' : ' . $result['sub_msg'];
            }
        }

        $return = array(
            'outTradeNo' => $outTradeNo,
            'data' => $url
        );

        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    case 'getpayurl':
        $outTradeNo = $data_array['outTradeNo']; //你自己的商品订单号
        $payAmount = $data_array['payAmount']; //付款金额，单位:元
        $orderName = $data_array['orderName']; //订单标题
        if ($outTradeNo == '') {
            $outTradeNo = uniqid();
        }
        if ($orderName == '') {
            $orderName = $storename;
        }
        $sql = "insert into payorders (orgid,storeid,storename,paytype,mchid,orderno,ordername,amount,status,addtime) values ('$orgid','$storeid','$storename','alipay','$mchid','$outTradeNo','$orderName','$payAmount','待支付',now())";
        if ($db->query($sql)) {
            $jsapiurl = 'alipay/wap.php?orderNo=' . $outTradeNo;
            //生成二维码
            // $url = getqrcode($jsapiurl);
        }

        $return = array(
            'outTradeNo' => $outTradeNo,
            'data' => $jsapiurl
        );

        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    case 'orderquery':
        $outTradeNo = $data_array['outTradeNo']; //要查询的订单号
        $tradeNo = '';
        require './query.php';

        $aliPay = new AlipayService();
        $aliPay->setAppid($appid);
        $aliPay->setRsaPrivateKey($rsaPrivateKey);
        $aliPay->setOutTradeNo($outTradeNo);
        $aliPay->setTradeNo($tradeNo);
        $result = $aliPay->doQuery();
        $result = $result['alipay_trade_query_response'];
        $sql = "insert into logs (orderno,result) values ('$outTradeNo','" . json_encode($result) . "')";
        $db->query($sql);
        $arr = array();
        if ($result['code'] == '10000' && $result['trade_status'] == 'TRADE_SUCCESS') {
            $trade_no = $result['trade_no'];
            $arr['return_code'] = 'SUCCESS';
            $arr['trade_state'] = 'SUCCESS';
            $arr['cash_fee'] = bcmul($result['buyer_pay_amount'], 100);
            $sql = "update payorders set transactionid='$trade_no',status = '支付成功',paytime = now(),result = '" . json_encode($result) . "' where paytype ='alipay' and orgid = '$orgid' and orderno = '$outTradeNo'";
            $db->query($sql);
        } elseif ($result['trade_status'] == 'WAIT_BUYER_PAY') {
            $arr['return_code'] = 'SUCCESS';
            $arr['trade_state'] = 'USERPAYING';
        } else {
            $arr['return_code'] = 'SUCCESS';
            $arr['trade_state'] = 'PAYERROR';
            $arr['trade_state_desc'] = $result['sub_msg'];
        }

        $return = array(
            'outTradeNo' => $outTradeNo,
            'tradeNo' => $result['trade_no'],
            'data' => $arr
        );

        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    case 'refund':
        $tradeNo = '';
        $orderno = $data_array['orderno'];
        $refundAmount = $data_array['refundAmount']; //退款金额，单位:元

        $aliPay = new AlipayService();
        $aliPay->setAppid($appid);
        $aliPay->setRsaPrivateKey($rsaPrivateKey);
        $aliPay->setTradeNo($tradeNo);
        $aliPay->setOutTradeNo($orderno);
        $aliPay->setRefundAmount($refundAmount);
        $result = $aliPay->doRefund();
        $result = $result['alipay_trade_refund_response'];
        if ($result['code'] == '10000') {
            $status = 'suc';
        } else {
            // echo $result['msg'] . ' : ' . $result['sub_msg'];
            $status = 'err';
        }

        $return = array(
            'status' => $status,
            'data' => $result
        );
        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    default:
        print_r($data_array);
        echo 'what do you want?';
}

function getqrcode($lessonUrl)
{
    $dirPath = "../public/qrcode/";
    $file = substr(md5($lessonUrl), 8, 16);
    $filename = $dirPath . $file . ".png";
    require "../public/phpqrcode.php";
    QRcode::png($lessonUrl, $filename, 'L', '8', 2);
    $codeurl  =  "public/qrcode/" . $file . ".png";
    return $codeurl;
}

function getCurrentUrl()
{
    $scheme = $_SERVER['HTTPS'] == 'on' ? 'https://' : 'http://';
    $uri = $_SERVER['PHP_SELF'] . $_SERVER['QUERY_STRING'];
    if ($_SERVER['REQUEST_URI']) $uri = $_SERVER['REQUEST_URI'];
    $baseUrl = urlencode($scheme . $_SERVER['HTTP_HOST'] . $uri);
    return $baseUrl;
}
