<?php
header('Content-type:text/html; Charset=utf-8');
require '../mysql.class.php';
require '../config.php';

writeLogFile(json_encode($_POST, JSON_UNESCAPED_UNICODE));
//支付宝公钥，账户中心->密钥管理->开放平台密钥，找到添加了支付功能的应用，根据你的加密类型，查看支付宝公钥
$alipayPublicKey = $aliconfig['alipayPublicKey'];

$aliPay = new AlipayService($alipayPublicKey);
//验证签名
$result = $aliPay->rsaCheck($_POST, $_POST['sign_type']);
if ($_POST['trade_status'] == 'TRADE_SUCCESS') {
    // 更新支付状态
    $outTradeNo = $_POST['out_trade_no']; //商品订单号
    $trade_no = $_POST['trade_no'];
    $pay_amount = $_POST['total_amount'];

    $sql = "select status from payorders where orderno = '$outTradeNo'";
    $data = $db->find($sql);
    $status = $data['status'];
    if ($status != '支付成功') {
        $sql = "update payorders set transactionid='$trade_no',status = '支付成功',paytime = now(),result = '" . json_encode($_POST) . "' where orderno = '$outTradeNo'";
        $db->query($sql);

        $sql = "select username,tel from payorders where orderno = '$outTradeNo'";
        $data = $db->find($sql);
        $tel = $data['tel'];
        if ($tel != '') {
            $username = $data['username'];
            $Message = $smsconfig['default'];
            // 替换模板参数
            $Message = str_replace('{username}', $username, $Message);
            // 加签名
            $Message = $smsconfig['sign'] . $Message;
            $data = array(
                'Id' =>  $smsconfig['id'],
                'Name' => $smsconfig['user'],
                'Psw' => $smsconfig['pwd'],
                'Message' => $Message,
                'Phone' => $tel,
                'Timestamp' => '0'
            );
            curlPost($smsconfig['url'], $data);
        }
    }
    //处理你的逻辑，例如获取订单号$_POST['out_trade_no']，订单金额$_POST['total_amount']等
    //程序执行完后必须打印输出“success”（不包含引号）。如果商户反馈给支付宝的字符不是success这7个字符，支付宝服务器会不断重发通知，直到超过24小时22分钟。一般情况下，25小时以内完成8次通知（通知的间隔频率一般是：4m,10m,10m,1h,2h,6h,15h）；
    echo 'success';
    exit();
}

function writeLogFile($message)
{
    // 获取当前时间
    $dateTime = date('Y-m-d H:i:s');

    $filename = './paylog.txt';

    // 拼接日志内容
    $logEntry = $dateTime . ' - ' . $message . PHP_EOL;

    // 写入日志文件
    file_put_contents($filename, $logEntry, FILE_APPEND);
}


function curlPost($url = '', $postData = '', $options = array())
{
    if (is_array($postData)) {
        $postData = http_build_query($postData);
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30); //设置cURL允许执行的最长秒数
    if (!empty($options)) {
        curl_setopt_array($ch, $options);
    }
    //https请求 不验证证书和host
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}

echo 'error';
exit();
class AlipayService
{
    //支付宝公钥
    protected $alipayPublicKey;
    protected $charset;

    public function __construct($alipayPublicKey)
    {
        $this->charset = 'utf8';
        $this->alipayPublicKey = $alipayPublicKey;
    }

    /**
     *  验证签名
     **/
    public function rsaCheck($params)
    {
        $sign = $params['sign'];
        $signType = $params['sign_type'];
        unset($params['sign_type']);
        unset($params['sign']);
        return $this->verify($this->getSignContent($params), $sign, $signType);
    }

    function verify($data, $sign, $signType = 'RSA')
    {
        $pubKey = $this->alipayPublicKey;
        $res = "-----BEGIN PUBLIC KEY-----\n" .
            wordwrap($pubKey, 64, "\n", true) .
            "\n-----END PUBLIC KEY-----";
        ($res) or die('支付宝RSA公钥错误。请检查公钥文件格式是否正确');

        //调用openssl内置方法验签，返回bool值
        if ("RSA2" == $signType) {
            $result = (bool)openssl_verify($data, base64_decode($sign), $res, version_compare(PHP_VERSION, '5.4.0', '<') ? SHA256 : OPENSSL_ALGO_SHA256);
        } else {
            $result = (bool)openssl_verify($data, base64_decode($sign), $res);
        }
        //        if(!$this->checkEmpty($this->alipayPublicKey)) {
        //            //释放资源
        //            openssl_free_key($res);
        //        }
        return $result;
    }

    /**
     * 校验$value是否非空
     *  if not set ,return true;
     *    if is null , return true;
     **/
    protected function checkEmpty($value)
    {
        if (!isset($value))
            return true;
        if ($value === null)
            return true;
        if (trim($value) === "")
            return true;
        return false;
    }

    public function getSignContent($params)
    {
        ksort($params);
        $stringToBeSigned = "";
        $i = 0;
        foreach ($params as $k => $v) {
            if (false === $this->checkEmpty($v) && "@" != substr($v, 0, 1)) {
                // 转换成目标字符集
                $v = $this->characet($v, $this->charset);
                if ($i == 0) {
                    $stringToBeSigned .= "$k" . "=" . "$v";
                } else {
                    $stringToBeSigned .= "&" . "$k" . "=" . "$v";
                }
                $i++;
            }
        }
        unset($k, $v);
        return $stringToBeSigned;
    }

    /**
     * 转换字符集编码
     * @param $data
     * @param $targetCharset
     * @return string
     */
    function characet($data, $targetCharset)
    {
        if (!empty($data)) {
            $fileType = $this->charset;
            if (strcasecmp($fileType, $targetCharset) != 0) {
                $data = mb_convert_encoding($data, $targetCharset, $fileType);
                //$data = iconv($fileType, $targetCharset.'//IGNORE', $data);
            }
        }
        return $data;
    }
}
