<?php
header('Content-type:text/html; Charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
date_default_timezone_set("PRC"); //设置时区

if (!$_POST) {
    header('location:/views');
    exit;
}

require './mysql.class.php';
require './config.php';

$url = file_get_contents("php://input");
$data_array = json_decode($url, true);
$type_txt = $data_array['type'];
switch ($type_txt) {
    case 'payorders_add':
        $paytype = $data_array['paytype'];
        $orderNo = $data_array['orderNo']; //你自己的商品订单号，不能重复
        $amount = $data_array['amount']; //付款金额，单位:元
        $orderName = $data_array['orderName']; //订单标题
        $remark = $data_array['remark']; //订单备注

        if ($orderNo == '') {
            $orderNo = uniqid();
        }
        if ($orderName == '') {
            $orderName = '支付测试';
        }
        if ($paytype == 'weixin') {
            $mchid = $config['mchid'];
        } else {
            $mchid = $aliconfig['appid'];
        }
        $sql = "insert into payorders (orgid,storeid,storename,paytype,mchid,orderno,ordername,amount,status,remark,addtime) values ('$orgid','$storeid','$storename','$paytype','$mchid','$orderNo','$orderName','$amount','待支付','$remark',now())";
        $db->query($sql);

        $return = array(
            'status' => 'suc',
            'orderNo' => $orderNo
        );

        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    case 'payorders_addex':
        $paytype = $data_array['paytype'];
        $orderNo = $data_array['orderNo']; //你自己的商品订单号，不能重复
        $amount = $data_array['amount']; //付款金额，单位:元
        $orderName = $data_array['orderName']; //订单标题

        $username = $data_array['username'];
        $sex = $data_array['sex'];
        $age = $data_array['age'];
        $profession = $data_array['usertype'];
        $mobile = $data_array['mobile'];
        $valid_code = $data_array['valid_code'];
        $valid = $data_array['valid'];
        if ($valid == '1') {
            if ($valid_code == '' || $valid_code != $_SESSION['randomNumber']) {
                $return = array(
                    'status' => 'err',
                    'info' => '验证码错误！'
                );
                echo json_encode($return, JSON_UNESCAPED_UNICODE);
                exit;
            }
        }

        if ($orderNo == '') {
            $orderNo = uniqid();
        }
        if ($orderName == '') {
            $orderName = '支付测试';
        }
        if ($paytype == 'weixin') {
            $mchid = $config['mchid'];
        } else {
            $mchid = $aliconfig['appid'];
        }
        $sql = "insert into payorders (orgid,storeid,storename,paytype,mchid,orderno,ordername,amount,username,sex,age,profession,tel,status,addtime) values ('$orgid','$storeid','$storename','$paytype','$mchid','$orderNo','$orderName','$amount','$username','$sex','$age','$profession','$mobile','待支付',now())";
        $db->query($sql);

        $return = array(
            'status' => 'suc',
            'orderNo' => $orderNo
        );

        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    case 'payorders_update':
        $orderNo = $data_array['orderNo']; //商品订单号
        $data = $data_array['data']; //支付返回数据
        $transaction_id = $data['transaction_id'];
        $sql = "update payorders set transactionid='$transaction_id',status = '支付成功',paytime = now(),result = '" . json_encode($data) . "' where orderno = '$orderNo'";
        $db->query($sql);

        $return = array(
            'status' => 'suc',
            'orderNo' => $orderNo
        );

        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    case 'payorders_get':
        $orgid = $data_array['orgid'];
        $storeid = $data_array['storeid'];

        if (!$_SESSION['orgid']) {
            $_SESSION['orgid'] = $orgid;
            $_SESSION['storeid'] = $storeid;
        }
        $startime = date("Y-m-d") . ' 00:00:00';
        $startime = date('Y-m-d', strtotime('-1 month', strtotime($startime)));
        $endtime = date("Y-m-d") . ' 23:59:59';

        $sql = "select storename,case paytype when 'weixin' then '微信' when 'alipay' then '支付宝' end as paytype,orderno,username,age,profession,tel,amount,status,addtime,paytime,remark 
        from payorders where addtime between '$startime' and '$endtime' and orgid ='$orgid' and storeid = '$storeid'";
        $data = $db->findAll($sql);
        $return = array(
            'status' => 'suc',
            'data' => $data
        );

        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    case 'sendSms':
        $Phone = $data_array['Phone'];
        $random = $data_array['random'];
        if ($random) {
            // 避免重复发送验证码
            // if ($_SESSION['randomNumber']) {

            // }
            $randomNumber = rand(100000, 999999);
            $Message = '您的验证码为：' . $randomNumber . '，请勿泄露，如非本人操作，请忽略本条短信。';
            $_SESSION['randomNumber'] = $randomNumber;
        } else {
            $username = $data_array['username'];
            $Message = $smsconfig['default'];
            // 替换模板参数
            $Message = str_replace('{username}', $username, $Message);
        }

        // 加签名
        $Message = $smsconfig['sign'] . $Message;
        $data = array(
            'Id' =>  $smsconfig['id'],
            'Name' => $smsconfig['user'],
            'Psw' => $smsconfig['pwd'],
            'Message' => $Message,
            'Phone' => $Phone,
            'Timestamp' => '0'
        );

        $return = curlPost($smsconfig['url'], $data);
        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    default:
        echo 'what do you want?';
}

function curlPost($url = '', $postData = '', $options = array())
{
    if (is_array($postData)) {
        $postData = http_build_query($postData);
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30); //设置cURL允许执行的最长秒数
    if (!empty($options)) {
        curl_setopt_array($ch, $options);
    }
    //https请求 不验证证书和host
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}
