function barcode(type, payAmount, authCode, outTradeNo, orderName) {
    $url = sysconfig.url;
    $url = $url + '/' + type + '/';
    $data = {
        type: 'barcode',
        orgid: sysconfig.orgid,
        storeid: sysconfig.storeid,
        storename: sysconfig.storename,
        outTradeNo: generateOrderNumber(),
        orderName: orderName,
        payAmount: payAmount,
        authCode: authCode
    }
    $return = "";
    $.ajax({
        url: $url,
        data: JSON.stringify($data),
        type: 'post',
        async: false,
        success: function (res) {
            res = JSON.parse(res)
            $return = {
                outTradeNo: res.outTradeNo,
                data: res.data
            };
        },
    })
    return $return;
}

function getqrcode(type, payAmount, outTradeNo, orderName) {
    $url = sysconfig.url;
    $url = $url + '/' + type + '/';
    $data = {
        type: 'getqrcode',
        orgid: sysconfig.orgid,
        storeid: sysconfig.storeid,
        storename: sysconfig.storename,
        outTradeNo: generateOrderNumber(),
        orderName: orderName,
        payAmount: payAmount
    }
    $return = "";
    $.ajax({
        url: $url,
        data: JSON.stringify($data),
        type: 'post',
        async: false,
        success: function (res) {
            res = JSON.parse(res)
            $return = {
                outTradeNo: res.outTradeNo,
                data: sysconfig.url + '/' + res.data
            };
        },
    })
    return $return;
}

function getpayurl(type, payAmount, outTradeNo, orderName) {
    $url = sysconfig.url;
    $url = $url + '/' + type + '/';
    $data = {
        type: 'getpayurl',
        orgid: sysconfig.orgid,
        storeid: sysconfig.storeid,
        storename: sysconfig.storename,
        outTradeNo: generateOrderNumber(),
        orderName: orderName,
        payAmount: payAmount
    }
    $return = "";
    $.ajax({
        url: $url,
        data: JSON.stringify($data),
        type: 'post',
        async: false,
        success: function (res) {
            res = JSON.parse(res)
            $return = {
                outTradeNo: res.outTradeNo,
                data: sysconfig.url + '/' + res.data
            };
        },
    })
    return $return;
}

function orderquery(type, outTradeNo) {
    $url = sysconfig.url;
    $url = $url + '/' + type + '/';
    $data = {
        type: 'orderquery',
        orgid: sysconfig.orgid,
        storeid: sysconfig.storeid,
        outTradeNo: outTradeNo
    }
    $return = "";
    $.ajax({
        url: $url,
        data: JSON.stringify($data),
        type: 'post',
        async: false,
        success: function (res) {
            res = JSON.parse(res)
            $return = {
                data: res.data
            };
        },
    })
    return $return;
}

function refund(type, orderno, $Amount, $refundAmount) {
    $url = sysconfig.url;
    $url = $url + '/' + type + '/';
    $data = {
        type: 'refund',
        orgid: sysconfig.orgid,
        storeid: sysconfig.storeid,
        orderno: orderno,
        Amount: $Amount,
        refundAmount: $refundAmount
    }
    $return = "";
    $.ajax({
        url: $url,
        data: JSON.stringify($data),
        type: 'post',
        async: false,
        success: function (res) {
            res = JSON.parse(res)
            $return = {
                data: res.data
            };
        },
    })
    return $return;
}

function payorders() {
    $url = sysconfig.url + '/';
    $data = {
        type: 'payorders_get',
        orgid: sysconfig.orgid,
        storeid: sysconfig.storeid
    }
    $return = "";
    $.ajax({
        url: $url,
        data: JSON.stringify($data),
        type: 'post',
        async: false,
        success: function (res) {
            res = JSON.parse(res)
            $return = {
                data: res.data
            };
        },
    })
    return $return;
}

// 生成随机订单号
function generateOrderNumber() {
    var timestamp = new Date().getTime();
    var randomNum = Math.floor(Math.random() * 1000000);
    return timestamp.toString() + randomNum.toString();
}