// 支付信息,默认第一个选项值
var payDetail = {
    paytype: 'weixin',
    amount: 0.1,
    orderNo: generateOrderNumber(),
    orderName: '连续包月'
};

$(function () {
    $(".aui-cho-box li").click(function () {
        $(this).addClass("on").siblings().removeClass("on");
        var money = $(".aui-cho-box").children("li.on").children("i").text();
        var count = $(".auiSks").val();
        payDetail.orderName = $(".aui-cho-box").children("li.on").children("div").children("h3").text();
        payDetail.amount = money * count;
        $(".aui-total span").text(payDetail.amount);
    });

    $(".weixin").click(function () {
        payDetail.paytype = "weixin";
        $(".input-weixin").prop("checked", true);
    });

    $(".alipay").click(function () {
        payDetail.paytype = "alipay";
        $(".input-alipay").prop("checked", true);
    });

    // 立即支付
    $(".aui-tabBar-btn").click(function () {
        payorders_add();
        if (payDetail.paytype == "weixin") {
            window.location.href = "/weixin/jsapi2.php?orderNo=" + payDetail.orderNo;
        } else {
            window.location.href = "/alipay/wap.php?orderNo=" + payDetail.orderNo;
        };
    })

});

// 生成随机订单号
function generateOrderNumber() {
    var timestamp = new Date().getTime();
    var randomNum = Math.floor(Math.random() * 1000000);
    return timestamp.toString() + randomNum.toString();
}

function payorders_add() {
    $data = {
        type: 'payorders_add',
        paytype: payDetail.paytype,
        orderNo: payDetail.orderNo,
        orderName: payDetail.orderName,
        amount: payDetail.amount,
    }
    $return = "";
    $.ajax({
        url: '/index.php',
        data: JSON.stringify($data),
        type: 'post',
        async: false,
        success: function (res) {
            res = JSON.parse(res)
            $return = {
                orderNo: res.orderNo,
                data: res.data
            };
        },
    })
    return $return;
}
