<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(-1);
header('Content-type:text/html; Charset=utf-8');
require '../mysql.class.php';
require '../config.php';
$url = file_get_contents("php://input");
$data_array = json_decode($url, true);

$mchid = $config['mchid'];  //微信支付商户号 PartnerID 通过微信支付商户资料审核后邮件发送
$appid = $config['appid'];  //微信支付申请对应的公众号的APPID
$appKey = $config['appKey'];    //微信支付申请对应的公众号的APP Key
$apiKey = $config['key'];   //https://pay.weixin.qq.com 帐户设置-安全设置-API安全-API密钥-设置API密钥
$notifyUrl = $config['notifyUrl'];  //付款成功后的回调地址(不要有问号)

// 判断请求类型
$type_txt = $data_array['type'];
switch ($type_txt) {
    case 'barcode':
        require './barcode.php';
        $outTradeNo = $data_array['outTradeNo']; //你自己的商品订单号，不能重复
        $payAmount = $data_array['payAmount']; //付款金额，单位:元
        $orderName = $data_array['orderName']; //订单标题
        $authCode = $data_array['authCode']; //用户付款码（商户使用设备扫码用户的付款条码读取到的条码数字，或 打开微信-》我-》钱包-》收付款 点击可查看付款码数字）
        if ($outTradeNo == '') {
            $outTradeNo = uniqid();
        }
        if ($orderName == '') {
            $orderName = $storename;
        }
        $sql = "insert into payorders (orgid,storeid,storename,paytype,mchid,orderno,ordername,amount,status,addtime) values ('$orgid','$storeid','$storename','weixin','$mchid','$outTradeNo','$orderName','$payAmount','待支付',now())";
        if ($db->query($sql)) {
            $wxPay = new WxpayService($mchid, $appid, $apiKey);
            $wxPay->setTotalFee($payAmount);
            $wxPay->setOutTradeNo($outTradeNo);
            $wxPay->setOrderName($orderName);
            $wxPay->setAuthCode($authCode);
            $arr = $wxPay->createJsBizPackage();
            if ($arr['return_code'] == 'SUCCESS' && $arr['result_code'] == 'SUCCESS') {
                $transaction_id = $arr['transaction_id'];
                $sql = "update payorders set transactionid='$transaction_id',status = '支付成功',paytime = now(),result = '" . json_encode($arr) . "' where paytype ='weixin' and mchid = '$mchid' and orderno = '$outTradeNo'";
                $db->query($sql);
            }
        }

        $return = array(
            'outTradeNo' => $outTradeNo,
            'data' => $arr
        );

        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    case 'getqrcode':
        require './native.php';
        $outTradeNo = $data_array['outTradeNo']; //你自己的商品订单号
        $payAmount = $data_array['payAmount']; //付款金额，单位:元
        $orderName = $data_array['orderName']; //订单标题
        $notifyUrl = $config['notifyUrl']; //付款成功后的回调地址(不要有问号)
        $payTime = time(); //付款时间

        if ($outTradeNo == '') {
            $outTradeNo = uniqid();
        }
        if ($orderName == '') {
            $orderName = $storename;
        }
        $sql = "insert into payorders (orgid,storeid,storename,paytype,mchid,orderno,ordername,amount,status,addtime) values ('$orgid','$storeid','$storename','weixin','$mchid','$outTradeNo','$orderName','$payAmount','待支付',now())";
        if ($db->query($sql)) {
            $wxPay = new WxpayService($mchid, $appid, $apiKey);
            $arr = $wxPay->createJsBizPackage($payAmount, $outTradeNo, $orderName, $notifyUrl, $payTime);
            //生成二维码
            $url = getqrcode($arr['code_url']);
        }
        $return = array(
            'outTradeNo' => $outTradeNo,
            'data' => $url
        );

        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    case 'getpayurl':
        $outTradeNo = $data_array['outTradeNo']; //你自己的商品订单号
        $payAmount = $data_array['payAmount']; //付款金额，单位:元
        $orderName = $data_array['orderName']; //订单标题
        if ($outTradeNo == '') {
            $outTradeNo = uniqid();
        }
        if ($orderName == '') {
            $orderName = $storename;
        }
        $sql = "insert into payorders (orgid,storeid,storename,paytype,mchid,orderno,ordername,amount,status,addtime) values ('$orgid','$storeid','$storename','weixin','$mchid','$outTradeNo','$orderName','$payAmount','待支付',now())";
        if ($db->query($sql)) {
            $jsapiurl = 'weixin/jsapi2.php?orderNo=' . $outTradeNo;
            //生成二维码
            // $url = getqrcode($jsapiurl);
        }

        $return = array(
            'outTradeNo' => $outTradeNo,
            'data' => $jsapiurl
        );

        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;
    case 'orderquery':
        $outTradeNo = $data_array['outTradeNo']; //要查询的订单号
        require './orderquery.php';
        $wxPay = new WxpayService($mchid, $appid, $apiKey);
        $result = $wxPay->orderquery($outTradeNo);
        $sql = "insert into logs (orderno,result) values ('$outTradeNo','" . json_encode($result) . "')";
        $db->query($sql);
        if ($result['return_code'] == 'SUCCESS' && $result['result_code'] == 'SUCCESS' && $result['trade_state'] == 'SUCCESS') {
            $transaction_id = $result['transaction_id'];
            $sql = "update payorders set transactionid='$transaction_id',status = '支付成功',paytime = now(),result = '" . json_encode($result) . "' where paytype ='weixin' and orgid = '$orgid' and orderno = '$outTradeNo'";
            $db->query($sql);
        }
        $return = array(
            'data' => $result
        );
        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    case 'refund':
        $orderno = $data_array['orderno']; //商户订单号
        $wxOrderNo = $data_array['wxOrderNo']; //微信订单号（商户订单号与微信订单号二选一，至少填一个）
        $Amount = $data_array['Amount']; //订单金额，单位:元
        $refundAmount = $data_array['refundAmount']; //退款金额，单位:元
        $refundNo = $data_array['refundNo']; //退款订单号(可随机生成)
        if ($refundNo == '') {
            $refundNo = uniqid();
        }
        require './refund.php';
        $wxPay = new WxpayService($mchid, $appid, $apiKey, $config['sslcert'], $config['sslkey']);
        $result = $wxPay->doRefund($Amount, $refundAmount, $refundNo, $wxOrderNo, $orderno);
        if ($result === true) {
            $status = 'suc';
            $sql = "update payorders status = '已退款',refundtime = now() where paytype ='weixin' and orgid = '$orgid' and orderno = '$orderno'";
            $db->query($sql);
        } else {
            $status = 'err';
        }

        $return = array(
            'status' => $status,
        );
        echo json_encode($return, JSON_UNESCAPED_UNICODE);
        break;

    default:
        print_r($data_array);
        echo 'what do you want?';
}

function getqrcode($lessonUrl)
{
    $dirPath = "../public/qrcode/";
    $file = substr(md5($lessonUrl), 8, 16);
    $filename = $dirPath . $file . ".png";
    require "../public/phpqrcode.php";
    QRcode::png($lessonUrl, $filename, 'L', '8', 2);
    $codeurl  =  "public/qrcode/" . $file . ".png";
    return $codeurl;
}
