<?php
defined('IN_IA') or exit('Access Denied');
load()->classs('weixin.account');
load()->func('communication');

class weixinstore extends WeiXinAccount
{
    public $account = null;

    public function __construct($acid = '') {
        $this->account_api = self::create($acid);
        $this->account = $this->account_api->account;
    }
    public function getAccessToken() {
        return $this->account_api->getAccessToken();
    }
    //获取商家类目
    public function getMerchantCategory()
    {
        $token = $this->getAccessToken();
        if (is_error($token)) {
            return $token;
        }
        $response = ihttp_request("https://api.weixin.qq.com/wxa/get_merchant_category?access_token=$token");
        if(is_error($response)) {
            return error(-1, "访问公众平台接口失败, 错误: {$response['message']}");
        } else {
            $response = @json_decode($response['content'], true);
            if ($response['status'] != 0) {
                return error(-1, $response['message']);
            } else {
                return $response;
            }
        }
    }
    //从腾讯地图拉取省市区信息
    public function getDistrict() {
        $token = $this->getAccessToken();
        if (is_error($token)) {
            return $token;
        }
        $response = ihttp_request("https://api.weixin.qq.com/wxa/get_district?access_token=$token");
        if(is_error($response)) {
            return error(-1, "访问公众平台接口失败, 错误: {$response['message']}");
        } else {
            $response = @json_decode($response['content'], true);
            if ($response['status'] != 0) {
                return error(-1, $response['message']);
            } else {
                return $response;
            }
        }
    }
    //在腾讯地图中搜索门店
    public function searchMapPoi($districtid, $keyword) {
        $token = $this->getAccessToken();
        if (is_error($token)) {
            return $token;
        }
        $response = $this->requestWx("https://api.weixin.qq.com/wxa/search_map_poi?access_token=$token",json_encode(array(
            'districtid' => intval($districtid),
            'keyword' => urlencode($keyword)
        ), JSON_UNESCAPED_UNICODE));
        if (is_error($response)) {
            return $response;
        } else {
            return $response['data']['item'];
        }
    }

    // 申请门店小程序
    public function applyMerchant($params) {
        $token = $this->getAccessToken();
        if (is_error($token)) {
            return $token;
        }
        $data = array(
            'first_catid' => $params['first_catid'],
            'second_catid' => $params['second_catid'],
            'nickname' => urlencode($params['nickname']),
            'intro' => urlencode($params['intro']),
        );
        $media = $this->uploadMedia($params['headimg_mediaid']);
        if (is_error($media)) {
            return $media;
        } else {
            $data['headimg_mediaid'] = $media['media_id'];
        }
        if (!empty($params['org_code'])) {
            $media = $this->uploadMedia($params['org_code']);
            if (is_error($media)) {
                return $media;
            } else {
                $data['org_code'] = $media['media_id'];
            }
        }
        if (!empty($params['qualification_list'])) {
            $images = array();
            foreach ($params['qualification_list'] as $item) {
                $media = $this->uploadMedia($item);
                if (is_error($media)) {
                    return $media;
                } else {
                    $images[] = $media['media_id'];
                }
            }
            $data['qualification_list'] = implode(' ', $images);
        }
        if (!empty($params['other_file'])) {
            $images = array();
            foreach ($params['other_file'] as $item) {
                $media = $this->uploadMedia($item);
                if (is_error($media)) {
                    return $media;
                } else {
                    $images[] = $media['media_id'];
                }
            }
            $data['other_file'] = implode(' ', $images);
        }
        $response = $this->requestWx(
            "https://api.weixin.qq.com/wxa/apply_merchant?access_token=$token",
            urldecode(json_encode($data))
        );
        if (is_error($response)) {
            return $response;
        } else {
            return true;
        }
    }
    // 修改门店小程序
    public function modifyMerchant($data) {
        $token = $this->getAccessToken();
        if (is_error($token)) {
            return $token;
        }
        $media = $this->uploadMedia($data['headimg_mediaid']);
        if (is_error($media)) {
            return $media;
        } else {
            $data['headimg_mediaid'] = $media['media_id'];
        }
        return $this->requestWx(
            "https://api.weixin.qq.com/wxa/modify_merchant?access_token=$token",
            urldecode(json_encode(array(
                'headimg_mediaid' => $data['headimg_mediaid'],
                'intro' => urlencode($data['intro']),
            )))
        );
    }
    // 查询门店小程序审核结果
    public function merchantAudit() {
        $token = $this->getAccessToken();
        if (is_error($token)) {
            return $token;
        }
        return $this->requestWx("https://api.weixin.qq.com/wxa/get_merchant_audit_info?access_token={$token}");
    }
    // 添加门店
    public function addStore($params) {
        if(empty($params)) {
            return error(-1, '门店信息不能为空');
        }
        $token = $this->getAccessToken();
        if (is_error($token)) {
            return $token;
        }
        $data = array(
            'map_poi_id' => $params['map_poi_id'],
            'contract_phone' => $params['contract_phone'],
            'hour' => $params['hour'],
            'credential' => $params['credential'],
            'card_id' => $params['card_id'],
        );
        if (!empty($params['poi_id'])) {
            $data['poi_id'] = $params['poi_id'];
        }
        if (!empty($params['company_name']) && !empty($params['qualification_list'])) {
            $data['company_name'] = $params['company_name'];
            $images = array();
            foreach ($params['qualification_list'] as $item) {
                $media = $this->uploadMedia($item);
                if (is_error($media)) {
                    return $media;
                } else {
                    $images[] = $media['media_id'];
                }
                $data['qualification_list'] = implode(' ', $images);
            }
        }
        if (empty($params['pic_list']) || !is_array($params['pic_list'])) {
            return error(-1, '门店图片不能为空');
        } else {
            $images = pdo_fetchall('SELECT attachment FROM '. tablename('wechat_attachment') . ' WHERE media_id IN ("' . implode('","', $params['pic_list']) . '")');
            if (empty($images)) {
                return error(-1, '门店图片不能为空！');
            }
            foreach ($images as $img) {
                $data['pic_list']['list'][] = $img['attachment'];
            }
            $data['pic_list'] = addslashes(stripslashes(json_encode($data['pic_list'])));
        }
        return $this->requestWx("https://api.weixin.qq.com/wxa/add_store?access_token={$token}", stripslashes(json_encode($data)));
    }

    // 修改门店信息
    public function updateStore($params) {
        $token = $this->getAccessToken();
        if (is_error($token)) {
            return $token;
        }
        $data = array(
            'poi_id' => $params['poi_id'],
            'hour' => $params['hour'],
            'contract_phone' => $params['contract_phone'],
            'card_id' => $params['card_id'],
        );
        if (empty($params['pic_list']) || !is_array($params['pic_list'])) {
            return error(-1, '门店图片不能为空');
        } else {
            $images = pdo_fetchall('SELECT attachment FROM '. tablename('wechat_attachment') . ' WHERE media_id IN ("' . implode('","', $params['pic_list']) . '")');
            if (empty($images)) {
                return error(-1, '门店图片不能为空！');
            }
            foreach ($images as $img) {
                $data['pic_list']['list'][] = $img['attachment'];
            }
            $data['pic_list'] = addslashes(stripslashes(json_encode($data['pic_list'])));
        }
        return $this->requestWx("https://api.weixin.qq.com/wxa/update_store?access_token={$token}", stripslashes(json_encode($data)));
    }
    //获取单个门店信息
    public function getStoreInfo($poi_id) {
        $token = $this->getAccessToken();
        if (is_error($token)) {
            return $token;
        }
        return $this->requestWx(
            "https://api.weixin.qq.com/wxa/get_store_info?access_token={$token}",
            json_encode(array('poi_id' => $poi_id))
        );
    }
    //获取门店列表
    public function getStoreList($data = array()) {
        $token = $this->getAccessToken();
        if (is_error($token)) {
            return $token;
        }
        return $this->requestWx(
            "https://api.weixin.qq.com/wxa/get_store_list?access_token={$token}",
            json_encode(array(
                'offset' => isset($data['offset']) ? intval($data['offset']) : 0,
                'limit' => $data['offset'] ? intval($data['limit']) : 40,
            ))
        );
    }

    //删除门店
    public function delStore($poi_id) {
        $token = $this->getAccessToken();
        if (is_error($token)) {
            return $token;
        }
        return $this->requestWx(
            "https://api.weixin.qq.com/wxa/del_store?access_token={$token}",
            json_encode(array('poi_id' => $poi_id))
        );
    }

    public function requestWx($url, $post) {
        $response = ihttp_request($url, $post);
        $result = @json_decode($response['content'], true);
        if(is_error($response)) {
            return error($result['errcode'], "访问公众平台接口失败: {$this->error_code($result['errcode'])}");
        }
        if(empty($result)) {
            return error(-1, "接口调用失败, 元数据: {$response['meta']}");
        } elseif(!empty($result['errcode'])) {
            return error($result['errcode'], "访问公众平台接口失败：{$this->wxErrorode($result['errcode'])}");
        }
        return $result;
    }
    public function wxErrorode($code, $errmsg = '未知错误') {
        $errors = array(
            '-1' => '系统错误',
            '0' => '请求成功',
            '40001' => '获取access_token时AppSecret错误，或者access_token无效',
            '40002' => '不合法的凭证类型',
            '40003' => '不合法的OpenID',
            '40004' => '不合法的媒体文件类型',
            '40005' => '不合法的文件类型',
            '40006' => '不合法的文件大小',
            '40007' => '不合法的媒体文件id',
            '40008' => '不合法的消息类型',
            '40009' => '不合法的图片文件大小',
            '40010' => '不合法的语音文件大小',
            '40011' => '不合法的视频文件大小',
            '40012' => '不合法的缩略图文件大小',
            '40013' => '不合法的APPID',
            '40014' => '不合法的access_token',
            '40015' => '不合法的菜单类型',
            '40016' => '不合法的按钮个数',
            '40017' => '不合法的按钮个数',
            '40018' => '不合法的按钮名字长度',
            '40019' => '不合法的按钮KEY长度',
            '40020' => '不合法的按钮URL长度',
            '40021' => '不合法的菜单版本号',
            '40022' => '不合法的子菜单级数',
            '40023' => '不合法的子菜单按钮个数',
            '40024' => '不合法的子菜单按钮类型',
            '40025' => '不合法的子菜单按钮名字长度',
            '40026' => '不合法的子菜单按钮KEY长度',
            '40027' => '不合法的子菜单按钮URL长度',
            '40028' => '不合法的自定义菜单使用用户',
            '40029' => '不合法的oauth_code',
            '40030' => '不合法的refresh_token',
            '40031' => '不合法的openid列表',
            '40032' => '不合法的openid列表长度',
            '40033' => '不合法的请求字符，不能包含\uxxxx格式的字符',
            '40035' => '不合法的参数',
            '40038' => '不合法的请求格式',
            '40039' => '不合法的URL长度',
            '40050' => '不合法的分组id',
            '40051' => '分组名字不合法',
            '40155' => '请勿添加其他公众号的主页链接',
            '41001' => '缺少access_token参数',
            '41002' => '缺少appid参数',
            '41003' => '缺少refresh_token参数',
            '41004' => '缺少secret参数',
            '41005' => '缺少多媒体文件数据',
            '41006' => '缺少media_id参数',
            '41007' => '缺少子菜单数据',
            '41008' => '缺少oauth code',
            '41009' => '缺少openid',
            '42001' => 'access_token超时',
            '42002' => 'refresh_token超时',
            '42003' => 'oauth_code超时',
            '43001' => '需要GET请求',
            '43002' => '需要POST请求',
            '43003' => '需要HTTPS请求',
            '43004' => '需要接收者关注',
            '43005' => '需要好友关系',
            '44001' => '多媒体文件为空',
            '44002' => 'POST的数据包为空',
            '44003' => '图文消息内容为空',
            '44004' => '文本消息内容为空',
            '45001' => '多媒体文件大小超过限制',
            '45002' => '消息内容超过限制',
            '45003' => '标题字段超过限制',
            '45004' => '描述字段超过限制',
            '45005' => '链接字段超过限制',
            '45006' => '图片链接字段超过限制',
            '45007' => '语音播放时间超过限制',
            '45008' => '图文消息超过限制',
            '45009' => '接口调用超过限制',
            '45010' => '创建菜单个数超过限制',
            '45015' => '回复时间超过限制',
            '45016' => '系统分组，不允许修改',
            '45017' => '分组名字过长',
            '45018' => '分组数量超过上限',
            '45056' => '创建的标签数过多，请注意不能超过100个',
            '45057' => '该标签下粉丝数超过10w，不允许直接删除',
            '45058' => '不能修改0/1/2这三个系统默认保留的标签',
            '45059' => '有粉丝身上的标签数已经超过限制',
            '45065' => '24小时内不可给该组人群发该素材',
            '45157' => '标签名非法，请注意不能和其他标签重名',
            '45158' => '标签名长度超过30个字节',
            '45159' => '非法的标签',
            '46001' => '不存在媒体数据',
            '46002' => '不存在的菜单版本',
            '46003' => '不存在的菜单数据',
            '46004' => '不存在的用户',
            '47001' => '解析JSON/XML内容错误',
            '48001' => 'api功能未授权',
            '48003' => '请在微信平台开启群发功能',
            '50001' => '用户未授权该api',
            '40070' => '基本信息baseinfo中填写的库存信息SKU不合法。',
            '41011' => '必填字段不完整或不合法，参考相应接口。',
            '40056' => '无效code，请确认code长度在20个字符以内，且处于非异常状态（转赠、删除）。',
            '43009' => '无自定义SN权限，请参考开发者必读中的流程开通权限。',
            '43010' => '无储值权限,请参考开发者必读中的流程开通权限。',
            '43011' => '无积分权限,请参考开发者必读中的流程开通权限。',
            '40078' => '无效卡券，未通过审核，已被置为失效。',
            '40079' => '基本信息base_info中填写的date_info不合法或核销卡券未到生效时间。',
            '45021' => '文本字段超过长度限制，请参考相应字段说明。',
            '40080' => '卡券扩展信息cardext不合法。',
            '49004' => '签名错误。',
            '43012' => '无自定义cell跳转外链权限，请参考开发者必读中的申请流程开通权限。',
            '40099' => '该code已被核销。',
            '61005' => '缺少接入平台关键数据，等待微信开放平台推送数据，请十分钟后再试或是检查“授权事件接收URL”是否写错（index.php?c=account&amp;a=auth&amp;do=ticket地址中的&amp;符号容易被替换成&amp;amp;）',
            '61023' => '请重新授权接入该公众号',

            '85024' => '你申请的名称需要补充相应资料进行审核，此时请求参数org_code和other_files需要填写',
            '85025' => '管理员手机登记数量已超过上限，不能使用该主体开通门店',
            '85026' => '该微信号已绑定5个管理员，请使用另一个微信号完成信息登记',
            '85027' => '管理员身份证已登记过5次，请使用另一个身份证完成用户信息登记',
            '85028' => '该主体登记数量已超过上限，不能使用该主体开通门店',
            '85029' => '商家名称已被占用，请换一个重试',
            '85030' => '名称长度为4-30个字符（一个中文占两个字符），不能含有特殊字符及“微信”等保留字"',
            '85031' => '不能使用该名称',
            '85032' => '该名称在侵权投诉保护期，暂不支持申请，请重新提交一个新的名称',
            '85033' => '名称不能包含违反公众平台协议、相关法律法规和政策的内容，不得使用“微信”等保留字',
            '85034' => '商家名称在改名15天保护期内，请换一个重试。',
            '85035' => '需与该帐号相同主体才可申请',
            '85036' => '介绍中不得含有虚假的、冒充、利用他人名义的、容易构成混淆、误认的、法律、法规和政策禁止的内容',
            '85049' => '头像或者简介修改达到每个月上限',
            '43104' => '没有权限',
            '85050' => '正在审核中，请勿重复提交',
            '85053' => '请先成功创建门店后再调用',
            '85056' => '临时mediaid无效',

            '85038' => '请勿添加重复门店',
            '85039' => '此门店状态不能被获取信息',
            '85040' => '此门店已被绑定，无需重复绑定',
            '85041' => '该经营资质已添加，请勿重复添加。',
            '85042' => '附近地点添加数量达到上线，无法继续添加。',
            '85054' => '由于门店小程序还没升级成功，需要添写poi_id进行门店迁移',
            '85055' => 'map_poi_id 无效',

            '40097' => '输入参数有误',
            '65115' => '门店不存在',
            '65118' => '该门店状态不允许更新',
        );
        $code = strval($code);
        if($code == '40001' || $code == '42001') {
            return '微信公众平台授权异常, 系统已修复这个错误, 请刷新页面重试.';
        }
        if($errors[$code]) {
            return $errors[$code];
        } else {
            return $errmsg;
        }
    }
}
