//
//  HeaderFooterGrid.swift
//  GridLayout
//
//  Created by 朱克剛 on 2022/7/5.
//

import SwiftUI

struct HeaderFooterGrid: View {
    private let gridItem = [
        GridItem(),
        GridItem(),
        GridItem()
    ]
    

    var body: some View {
        ScrollView {
            LazyVGrid(columns: gridItem, pinnedViews: .sectionHeaders) {
                Section {
                    ForEach(1..<4) { i in
                        Color.yellow
                            .aspectRatio(contentMode: .fill)
                            .overlay {
                                Text("\(i)")
                            }
                    }
                } header: {
                    Text("翻譯文學")
                }
                
                Section {
                    ForEach(1..<6) { i in
                        Color.brown
                            .aspectRatio(contentMode: .fill)
                            .overlay {
                                Text("\(i)")
                            }
                    }
                } header: {
                    Text("科幻小說")
                }
            }
            .padding()
        }
    }
}

struct HeaderFooterGrid_Previews: PreviewProvider {
    static var previews: some View {
        HeaderFooterGrid()
    }
}
