//
//  NewGrid.swift
//  GridLayout
//
//  Created by 朱克剛 on 2022/7/6.
//

import SwiftUI

struct Square: View {
    var tag: Int
    var color: UIColor = .lightGray
    var body: some View {
        Color(uiColor: color)
            .frame(width: 80, height: 80)
            .overlay {
                Text("\(tag)")
            }
    }
}

struct SmallSquare: View {
    var tag: Int
    var body: some View {
        Color.white
            .frame(width: 30, height: 30)
            .border(.black)
            .overlay {
                Text("\(tag)")
            }
    }
}

struct NewGrid: View {
    var body: some View {
        Grid(alignment:.topLeading) {
            GridRow(alignment: .bottom) {
                SmallSquare(tag: 1)
                    .gridColumnAlignment(.trailing)
                Square(tag: 2)
                Square(tag: 3)
            }
            GridRow {
                SmallSquare(tag: 4)
                SmallSquare(tag: 5)
                    .gridCellAnchor(.bottom)
                Square(tag: 6, color: .gray)
                
            }
            GridRow {
                Square(tag: 7, color: .darkGray)
            }
        }
    }
}

struct NewGrid_Previews: PreviewProvider {
    static var previews: some View {
        NewGrid()
    }
}
