//
//  SimpleGrid.swift
//  GridLayout
//
//  Created by 朱克剛 on 2022/10/8.
//

import SwiftUI

struct SimpleGrid: View {
    private let gridItem = [
        GridItem(spacing: 2),
        GridItem(spacing: 2),
        GridItem()
    ]

    var body: some View {
        ScrollView {
            LazyVGrid(columns: gridItem, spacing: 2) {
                ForEach(1..<12) { i in
                    Color.yellow
                        .aspectRatio(contentMode: .fill)
                        .overlay {
                            Text("\(i)")
                        }
                }
            }
        }
    }
}

struct SimpleGrid_Previews: PreviewProvider {
    static var previews: some View {
        SimpleGrid()
    }
}
