//
//  LazyStack.swift
//  LayoutDemo
//
//  Created by 朱克剛 on 2022/10/8.
//

import SwiftUI

struct Item: View {
    var tag: Int
    
    init(tag: Int) {
        self.tag = tag
        print(tag) // <= DEBUG message
    }
    
    var body: some View {
        Text("\(tag)")
    }
}

struct LazyStack: View {
    var body: some View {
        ScrollView {
            LazyVStack {
                ForEach(1..<200) {
                    Item(tag: $0)
                }
            }
        }
    }
}

struct LazyStack_Previews: PreviewProvider {
    static var previews: some View {
        LazyStack()
    }
}
