//
//  SizeClasses.swift
//  LayoutDemo
//
//  Created by 朱克剛 on 2022/9/8.
//

import SwiftUI

struct SizeClasses: View {
    @Environment(\.horizontalSizeClass) var widthClass
    @Environment(\.verticalSizeClass) var heightClass
    
var body: some View {
    VStack(alignment: .leading) {
        if widthClass == .compact {
            Text("Width: compact")
        } else {
            Text("Width: regular")
        }
    
        if heightClass == .compact {
            Text("Height: compact")
        } else {
            Text("Height: regular")
        }
    }
}
}

struct SizeClasses_Previews: PreviewProvider {
    static var previews: some View {
        SizeClasses()
    }
}
