//
//  TraitLayout.swift
//  LayoutDemo
//
//  Created by 朱克剛 on 2022/9/8.
//

import SwiftUI

struct TraitLayout: View {
    @Environment(\.horizontalSizeClass) var widthClass
    @Environment(\.verticalSizeClass) var heightClass

    var body: some View {
        if widthClass == .compact, heightClass == .regular {
            Text("Hello, World!")
        }
        
        if heightClass == .compact {
            Image(systemName: "globe")
        }
        
        if widthClass == .regular, heightClass == .regular {
            Text("Only for iPad").font(.largeTitle)
        }
    }
}

struct TraitLayout_Previews: PreviewProvider {
    static var previews: some View {
        TraitLayout()
    }
}
