//
//  ZIndex.swift
//  LayoutDemo
//
//  Created by 朱克剛 on 2022/10/8.
//

import SwiftUI

struct ZIndex: View {
    @State private var isOn = false
    var body: some View {
        VStack {
            Toggle("", isOn: $isOn)
            
            ZStack {
                Color
                    .white
                    .border(.black)
                    .frame(width: 200, height: 200)
                    .zIndex(isOn ? 2 : 0)
                
                Color
                    .gray
                    .frame(width: 200, height: 200)
                    .offset(x: 40, y: 40)
            }
        }
    }
}

struct ZIndex_Previews: PreviewProvider {
    static var previews: some View {
        ZIndex()
    }
}
