//
//  Sheet.swift
//  NextPage
//
//  Created by 朱克剛 on 2022/10/8.
//

import SwiftUI

struct Sheet: View {
    @State var isPresented = false
    
    var body: some View {
        VStack {
            Button("下一頁") {
                isPresented = true
            }
            .sheet(isPresented: $isPresented) {
                SecondPage()
                    .presentationDetents([
                        .medium,
                        .large,
                        .height(100),
                        .height(200),
                        .fraction(0.6)
                    ])
            }
        }
    }
}

struct Sheet_Previews: PreviewProvider {
    static var previews: some View {
        Sheet()
    }
}
