//
//  SplitViewThreeColumns.swift
//  NextPage
//
//  Created by 朱克剛 on 2022/10/8.
//

import SwiftUI

enum NumberType {
    case odd
    case even
}

struct SplitViewThreeColumns: View {
    @State private var sidebarId: NumberType?
    @State private var contentId: Int?
    
    private func getSequence(_ type: NumberType?) -> [Int] {
        switch type {
        case .odd:
            return Array(stride(from: 1, through: 10, by: 2))
        case .even:
            return Array(stride(from: 2, through: 10, by: 2))
        case .none:
            return []
        }
    }
    
    var body: some View {
        NavigationSplitView {
            // 第一欄
            List(selection: $sidebarId) {
                NavigationLink(value: NumberType.odd) {
                    Text("奇數")
                }
                NavigationLink(value: NumberType.even) {
                    Text("偶數")
                }
            }
            .scrollDisabled(true)
        } content: {
            // 第二欄
            List(selection: $contentId) {
                ForEach(getSequence(sidebarId), id: \.self) { value in
                    NavigationLink(value: value) {
                        Text(value, format: .number)
                    }
                }
            }
        } detail: {
            // 第三欄
            if let contentId {
                Text("最後選到的數字是 \(contentId)")
            } else {
                Text("尚未點選選項")
            }
        }

    }

}

struct SplitViewThreeColumns_Previews: PreviewProvider {
    static var previews: some View {
        SplitViewThreeColumns()
    }
}
