//
//  SplitViewTwoColumns.swift
//  NextPage
//
//  Created by 朱克剛 on 2022/10/8.
//

import SwiftUI

struct Language: Identifiable {
    let id = UUID()
    var name: String
}

var langs: [Language] = [
    .init(name: "Python"),
    .init(name: "C++"),
    .init(name: "Swift"),
    .init(name: "Java"),
    .init(name: "JavaScript")
]

struct SplitViewTwoColumns: View {
    @State private var selectedId: UUID?
    var body: some View {
        NavigationSplitView {
            // 左側 Sidebar 內容
            List(langs, selection: $selectedId) {
                Text($0.name)
            }
        } detail: {
            // 右側 Detail 內容
            let data = langs.first { lang in
                lang.id == selectedId
            }
            Text(data?.name ?? "")
        }
    }
}

struct SplitViewTwoColumns_Previews: PreviewProvider {
    static var previews: some View {
        SplitViewTwoColumns()
    }
}
