//
//  ContentView.swift
//  ContainerDemo
//
//  Created by 朱克剛 on 2022/8/31.
//

import SwiftUI

struct ContentView: View {
    var body: some View {
        NavigationStack {
            List {
                Section("List") {
                    NavigationLink("基本List", destination: SimpleList())
                    NavigationLink("區段、表頭與表尾", destination: ListSection())
                    NavigationLink("基本點選", destination: SimpleSelect())
                    NavigationLink("點選儲存格", destination: ListSelected())
                    NavigationLink("點選換頁", destination: ListAndNavigationStack())
                    NavigationLink("刪除Row", destination: DeleteRow())
                    NavigationLink("編輯模式", destination: ListEditMode())
                    NavigationLink("左滑右滑按鈕", destination: ListSwipeAction())
                    NavigationLink("搜尋", destination: ListAndSearch())
                }
                
                Section("OutlineGroup") {
                    NavigationLink("大綱", destination: Outline())
                }
                
                Section("ScrollView") {
                    NavigationLink("捲動到特定位置", destination: ManualScrolling())
                }
                
                Section("Table") {
                    NavigationLink("Table", destination: TableLayout())
                    NavigationLink("Table_ContextMenu", destination: TableLayout_ContextMenu())
                }
            }
        }
    }
}

struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
}
