//
//  ListAndNavigationStack.swift
//  ContainerDemo
//
//  Created by 朱克剛 on 2022/8/31.
//

import SwiftUI

struct ListAndNavigationStack: View {
    struct Restaurant: Identifiable, Hashable {
        var id = UUID()
        var name: String
    }

    struct Hotel: Identifiable, Hashable {
        var id = UUID()
        var name: String
    }

    @State private var spots: [Any] = [
        Hotel(name: "君悅酒店"),
        Hotel(name: "寒舍艾麗酒店"),
        Hotel(name: "晶華酒店"),
        Restaurant(name: "鼎泰豐"),
        Restaurant(name: "士林夜市")
    ]

    var body: some View {
        NavigationStack {
             List {
                 ForEach(0..<spots.count, id: \.self) { index in
                     if let spot = spots[index] as? Hotel {
                         NavigationLink(spot.name, value: spot)
                     }
                     else if let spot = spots[index] as? Restaurant {
                         NavigationLink(spot.name, value: spot)
                     }
                 }
             }
             .navigationTitle("旅遊指南")
             .navigationDestination(for: Hotel.self) { spot in
                 Text("飯店推薦：\(spot.name)")
             }
             .navigationDestination(for: Restaurant.self) { spot in
                 Text("餐廳推薦：\(spot.name)")
             }
         }
    }
}

struct ListAndNavigationStack_Previews: PreviewProvider {
    static var previews: some View {
        ListAndNavigationStack()
    }
}
