//
//  ListAndSearch.swift
//  ContainerDemo
//
//  Created by 朱克剛 on 2022/8/31.
//

import SwiftUI


struct ListAndSearch: View {
    @State private var text = ""
    var body: some View {
        NavigationStack {
            List {
                ForEach(items) { item in
                    if item.name.contains(text) || item.name.isEmpty {
                        Text(item.name)
                    }
                }
            }
            .searchable(text: $text)
        }
    }
}

struct ListAndSearch_Previews: PreviewProvider {
    static var previews: some View {
        ListAndSearch()
    }
}
