//
//  ListEditMode.swift
//  ContainerDemo
//
//  Created by 朱克剛 on 2022/8/31.
//

import SwiftUI

struct ListEditMode: View {
    var body: some View {
        NavigationStack {
            List {
                ForEach(items) { item in
                    Text(item.name)
                }
                .onDelete { indexSet in
                    items.remove(atOffsets: indexSet)
                }
                .onMove { indexSet, to in
                    items.move(fromOffsets: indexSet, toOffset: to)
                }
            }
            .navigationTitle("Languages")
            .toolbar {
                EditButton()
            }
        }
    }
}

struct ListEditMode_Previews: PreviewProvider {
    static var previews: some View {
        ListEditMode()
    }
}
