//
//  ListSelected.swift
//  ContainerDemo
//
//  Created by 朱克剛 on 2022/8/31.
//

import SwiftUI

struct ListSelected: View {
    @State private var selectedId: UUID?
    private func indicatorImage(_ selected: Bool) -> some View {
        Image(systemName: selected ? "checkmark.circle.fill" : "circle")
            .foregroundColor(selected ? .accentColor : .gray)
            .imageScale(.large)
    }

    
    var body: some View {
        List(items, selection: $selectedId) { item in
            HStack {
                indicatorImage(selectedId == item.id)
                Text(item.name)
            }
        }
    }
}

struct ListSelected_Previews: PreviewProvider {
    static var previews: some View {
        ListSelected()
    }
}
