//
//  ListSwipeAction.swift
//  ContainerDemo
//
//  Created by 朱克剛 on 2022/8/31.
//

import SwiftUI

struct ListSwipeAction: View {
    var body: some View {
        List {
            ForEach(items) { item in
                Text(item.name)
                    .swipeActions {
                        Button(role: .destructive) {
                            // 按鈕按下後要做的事情寫這
                        } label: {
                            Text("Delete")
                        }
                    }
                    .swipeActions(edge: .leading) {
                        Button {
                            // 按鈕按下後要做的事情寫這
                        } label: {
                            Label("Share", systemImage: "square.and.arrow.up")
                        }
                        .tint(.blue)
                        
                        Button {
                            // 按鈕按下後要做的事情寫這
                        } label: {
                            Label("Info", systemImage: "info.circle")
                        }
                        .tint(.purple)
                    }
            }
        }
    }
}

struct ListSwipeAction_Previews: PreviewProvider {
    static var previews: some View {
        ListSwipeAction()
    }
}
