//
//  ManualScrolling.swift
//  Scroll
//
//  Created by 朱克剛 on 2022/7/15.
//

import SwiftUI

struct ManualScrolling: View {
    @State private var proxy: ScrollViewProxy?
    @Namespace private var topID
    @Namespace private var bottomID
    
    var body: some View {
        ScrollViewReader { proxy in
            VStack {
                HStack {
                    Button("Top") {
                        withAnimation {
                            proxy.scrollTo(topID)
                        }
                    }
                    .buttonStyle(.borderedProminent)
                    
                    Button("Bottom") {
                        withAnimation {
                            proxy.scrollTo(bottomID)
                        }
                    }
                    .buttonStyle(.borderedProminent)
                }
                ScrollView {
                    VStack {
                        Text("Header").id(topID)
                        Divider()
                        ForEach(0..<20) {
                            Text("\($0)")
                        }
                        Divider()
                        Text("Footer").id(bottomID)
                    }
                }
                .frame(height: 200)
            }
        }
    }
}

struct ManualScrolling_Previews: PreviewProvider {
    static var previews: some View {
        ManualScrolling()
    }
}
