//
//  Outline.swift
//  ContainerDemo
//
//  Created by 朱克剛 on 2022/8/31.
//

import SwiftUI

struct Outline: View {
    struct Tree: Identifiable {
        let id = UUID()
        var name: String
        var children: [Tree]?
    }

    let data: [Tree] = [
        .init(name: "中文書", children: [
                .init(name: "翻譯文學"),
                .init(name: "心靈成長"),
                .init(name: "攝影")]),
        
        .init(name: "外文書", children: [
                .init(name: "日文", children: [
                        .init(name: "語言學習"),
                        .init(name: "文學")]),
                .init(name: "英文", children: [
                        .init(name: "語言學習"),
                        .init(name: "文學")])])
    ]
    
    var body: some View {
        List {
            ForEach(data) { section  in
                Section(section.name) {
                    OutlineGroup(section.children ?? [], children: \.children) { value in
                        Text(value.name)
                    }
                }
            }
        }
    }
}

struct Outline_Previews: PreviewProvider {
    static var previews: some View {
        Outline()
    }
}
