//
//  SimpleSelect.swift
//  ContainerDemo
//
//  Created by 朱克剛 on 2022/9/8.
//

import SwiftUI

struct Item: Identifiable, Hashable {
    let id = UUID()
    var name: String
}

var items: [Item] = [
    .init(name: "Python"),
    .init(name: "C++"),
    .init(name: "Swift"),
    .init(name: "Java"),
    .init(name: "JavaScript")
]

struct SimpleSelect: View {
    @State private var selectedId: UUID?
    
    var body: some View {
        List(items, selection: $selectedId) { item in
            Text(item.name)
        }
        .onChange(of: selectedId) { newValue in
            let tmp = items.first { item in
                item.id == selectedId
            }
            print(tmp?.name)
        }
    }
}

struct SimpleSelect_Previews: PreviewProvider {
    static var previews: some View {
        SimpleSelect()
    }
}
