//
//  TableLayout_ContextMenu.swift
//  ContainerDemo
//
//  Created by 朱克剛 on 2022/9/15.
//

import SwiftUI

struct TableLayout_ContextMenu: View {
    @Environment(\.horizontalSizeClass)
    var widthClass: UserInterfaceSizeClass?
    @Environment(\.verticalSizeClass)
    var heightClass: UserInterfaceSizeClass?
    
    struct Weather: Identifiable {
        let id = UUID()
        var city: String
        var highTemp: Int
        var lowTemp: Int
        var rain: Int
    }

    @State var today: [Weather] = [
        .init(city: "臺北", highTemp: 34, lowTemp: 26, rain: 70),
        .init(city: "新竹", highTemp: 32, lowTemp: 30, rain: 60),
        .init(city: "臺中", highTemp: 34, lowTemp: 31, rain: 60),
        .init(city: "高雄", highTemp: 36, lowTemp: 32, rain: 30),
        .init(city: "花蓮", highTemp: 31, lowTemp: 25, rain: 40)
    ]
    
    @State private var sortOrder = [KeyPathComparator(\Weather.highTemp)]
    @State private var selectedId = Set<UUID>()

    var body: some View {
        Table {
            TableColumn("城市") {
                Text($0.city)
            }
            TableColumn("高溫") {
                Text("\($0.highTemp) °C")
            }
            TableColumn("低溫") {
                Text("\($0.lowTemp) °C")
            }
            TableColumn("降雨機率") {
                Text("\($0.rain) %")
            }
        } rows: {
            ForEach(today) { row in
                TableRow(row)
                    .contextMenu {
                        if widthClass == .compact || heightClass == .compact {
                            Text("高溫 \(row.highTemp) °C")
                            Text("低溫 \(row.lowTemp) °C")
                            Text("降雨機率 \(row.lowTemp) %")
                        }
                    }
            }
        }

    }
}

struct TableLayout_ContextMenu_Previews: PreviewProvider {
    static var previews: some View {
        TableLayout_ContextMenu()
    }
}
