//
//  ContentView.swift
//  ShareLinkDemo
//
//  Created by 朱克剛 on 2022/8/21.
//

import SwiftUI

struct Photo: Transferable {
    static var transferRepresentation: some TransferRepresentation {
        ProxyRepresentation(exporting: \.image)
    }

    public var image: Image
    public var caption: String
}

struct ContentView: View {
    private let name = NSHomeDirectory() + "/Documents/a.txt"
    var body: some View {
        VStack {
            Button("存檔") {
                do {
                    try String("hello").write(
                            toFile: name,
                            atomically: true,
                            encoding: .utf8
                        )
                } catch {
                    print(error)
                }
            }
            ShareLink(
                item: URL(filePath: name),
                preview: .init("a.txt", image: Image("demo"))
            )
            Spacer()
        }
    }
}


struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
}
