//
//  ContentView.swift
//  TextDemo
//
//  Created by 朱克剛 on 2022/8/22.
//
import SwiftUI

extension Text {
    func lineGradient(_ gradient: LinearGradient) -> some View {
        self
            .overlay {
                gradient
                    .mask {
                        self
                    }
            }
    }
}

struct ContentView: View {
    private let gradient = LinearGradient(
        colors: [.white, .black],
        startPoint: .topLeading,
        endPoint: .bottomTrailing
    )
    
    var body: some View {
        /*
        Rectangle()
            .fill(gradient)
            .frame(width: 200, height: 200)
            .mask {
                Text("關關雎鳩，\n在河之洲。\n窈窕淑女，\n君子好逑。")
                    .font(.largeTitle)
            }
        */
        Text("關關雎鳩，\n在河之洲。\n窈窕淑女，\n君子好逑。")
            .font(.largeTitle)
            .lineGradient(gradient)
    }
}

struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
}
