//
//  RichText.swift
//  TextDemo
//
//  Created by 朱克剛 on 2022/8/22.
//

import SwiftUI

struct RichText: View {
    
    func richText() -> AttributedString {
        var attributedString = AttributedString("今天\n天氣晴")
        
        if let range = attributedString.range(of: "今天") {
            attributedString[range].font = .title2
        }
        
        if let range = attributedString.range(of: "天氣") {
            attributedString[range].foregroundColor = .blue
            attributedString[range].font = .body
        }
        
        if let range = attributedString.range(of: "晴") {
            attributedString[range].foregroundColor = .green
            attributedString[range].font = .largeTitle.bold()
        }
        
        
        return attributedString
    }
    
    var body: some View {
        Text(richText())
    }
}

struct RichText_Previews: PreviewProvider {
    static var previews: some View {
        RichText()
    }
}
