//
//  ContentView.swift
//  PhotoPickerDemo
//
//  Created by 朱克剛 on 2022/9/27.
//

import SwiftUI
import PhotosUI

struct ContentView: View {
    @State private var selectedItem: PhotosPickerItem?
    @State private var imageData: Data?
    var body: some View {
        NavigationStack {
            Group {
                if let imageData, let uiImage = UIImage(data: imageData) {
                    Image(uiImage: uiImage)
                        .resizable()
                        .scaledToFill()
                        .clipped()
                        .border(.gray)
                } else {
                    Image(systemName: "photo")
                        .navigationTitle("Hello")
                }
            }
            .frame(width: 200, height: 200)
            .background(.gray.opacity(0.2))
            .toolbar {
                PhotosPicker(
                    selection: $selectedItem,
                    matching: .images,
                    photoLibrary: .shared()
                ) {
                    Text("Pick a photo")
                }
                .onChange(of: selectedItem) { newValue in
                    Task {
                        if let data = try await selectedItem?.loadTransferable(type: Data.self) {
                            imageData = data
                        }
                    }
                }
            }
        }
        
    }
}

struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
}
