//
//  GaugeDemo.swift
//  StateDemo
//
//  Created by 朱克剛 on 2022/9/28.
//

import SwiftUI

struct GaugeDemo: View {
    var body: some View {
        VStack {
            Gauge(value: 0.7) {
                Text("Training...")
            }
            
            Gauge(value: 0.7) {
                Text("Training...")
            }
            .gaugeStyle(.accessoryLinearCapacity)
            
            Gauge(value: 0.4) {
                Text("Power")
            } currentValueLabel: {
                Text(0.4, format: .percent)
            } minimumValueLabel: {
                Image(systemName: "tortoise.fill")
            } maximumValueLabel: {
                Image(systemName: "hare.fill")
            }

            Gauge(value: 5626, in: 0...10000) {
                Image(systemName: "figure.walk")
            } currentValueLabel: {
                Text(5620, format: .number)
            }
            .gaugeStyle(.accessoryCircular)

            Gauge(value: 0.76) {
                Text(76, format: .percent)
            }
            .tint(.black)
            .gaugeStyle(.accessoryCircularCapacity)

        }
        .frame(width: 200)
    }
}

struct GaugeDemo_Previews: PreviewProvider {
    static var previews: some View {
        GaugeDemo()
    }
}
