//
//  BarChart.swift
//  BarChart
//
//  Created by 朱克剛 on 2022/8/28.
//

import SwiftUI
import Charts

struct BarChart: View {
    struct Product: Identifiable {
        var id = UUID()
        var name: String
        var count: Int
        var color: Color
    }
    
    var products: [Product] = [
        .init(name: "鉛筆", count: 10, color: .brown),
        .init(name: "橡皮擦", count: 5, color: .indigo),
        .init(name: "膠帶", count: 13, color: .mint)
    ]
    
    var body: some View {
        Chart {
            ForEach(products) { item in
                BarMark(
                    x: .value("名稱", item.name),
                    y: .value("銷售量", item.count)
                )
                .foregroundStyle(item.color)
                .annotation {
                    Text(item.count, format: .number)
                }
            }
        }
    }

}


struct BarChart_Previews: PreviewProvider {
    static var previews: some View {
        BarChart()
    }
}
