//
//  BoxChart.swift
//  ChartsDemo
//
//  Created by 朱克剛 on 2022/8/28.
//

import SwiftUI
import Charts

struct BoxChart: View {
    struct Box: Identifiable {
        var id = UUID()
        var name: String
        var min: Double
        var max: Double
        var q1: Double
        var q3: Double
        var median: Double
    }

    var boxData: [Box] = [
        .init(name: "A", min: 4, max: 21, q1: 6, q3: 15, median: 11),
        .init(name: "B", min: 12, max: 22, q1: 16, q3: 20, median: 17),
        .init(name: "C", min: 18, max: 32, q1: 23, q3: 28, median: 27)
    ]
    
    var body: some View {
        Chart(boxData) { box in
            // 用長條圖表示 Q1 到 Q3 資料
            BarMark(
                x: .value("Name", box.name),
                yStart: .value("Q1", box.q1),
                yEnd: .value("Q3", box.q3),
                width: .fixed(40)
            )
            .cornerRadius(6)

            // 畫出長條圖上下的垂直線條
            RuleMark(
                x: .value("Name", box.name),
                yStart: .value("Min", box.min),
                yEnd: .value("Max", box.max)
            )

            // 畫出最大值短線
            PointMark(
                x: .value("Name", box.name),
                y: .value("Max", box.max)
            )
            .annotation(alignment: .center, spacing: 0) {
                Color.blue.frame(width: 20, height: 2)
            }
            .symbolSize(0)

            // 畫出最小值短線
            PointMark(
                x: .value("Name", box.name),
                y: .value("Min", box.min)
            )
            .annotation(alignment: .center, spacing: -1) {
                Color.blue.frame(width: 20, height: 2)
            }
            .symbolSize(0)

            // 表示中位數
            RectangleMark(
                x: .value("Name", box.name),
                y: .value("Median", box.median),
                width: .fixed(40),
                height: .fixed(4)
            )
            .foregroundStyle(.black)
        }
    }
}

struct BoxChart_Previews: PreviewProvider {
    static var previews: some View {
        BoxChart()
    }
}
