//
//  ContentView.swift
//  ChartsDemo
//
//  Created by 朱克剛 on 2022/8/28.
//

import SwiftUI

struct ContentView: View {
    var body: some View {
        NavigationStack {
            List {
                Group {
                    NavigationLink("長條圖", destination: BarChart())
                    NavigationLink("堆疊長條圖", destination: StackedBarChart())
                    NavigationLink("群組長條圖", destination: GroupedBarChart())
                    NavigationLink("甘特圖", destination: GanttChart())
                    NavigationLink("折線圖", destination: LineChart())
                    NavigationLink("多折線圖", destination: TwoLinesChart())
                    NavigationLink("點形圖", destination: PointChart())
                    NavigationLink("基準線", destination: RuleLine())
                    NavigationLink("折線圖標記", destination: LineChartAnnotation())
                    NavigationLink("面積圖", destination: AreaChart())
                }
                NavigationLink("矩形圖", destination: RectangleChart())
                NavigationLink("熱區圖", destination: HeatMaps())
                NavigationLink("箱型圖", destination: BoxChart())
                NavigationLink("手勢", destination: Gesture())
                NavigationLink("客製化", destination: CustomStyle())
            }
        }
    }
}

struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
}
