//
//  CustomStyle.swift
//  ChartsDemo
//
//  Created by 朱克剛 on 2022/9/27.
//

import SwiftUI
import Charts

struct CustomStyle: View {
    struct Record: Identifiable {
        var publishTime: String
        var value: Int
        
        var id = UUID()
        var date: Date { // 將時間日期字串轉成標準的 Date
            get {
                let formatter = DateFormatter()
                formatter.dateFormat = "yyyy/M/d H:m:s"
                return formatter.date(from: publishTime)!
            }
        }
    }
    
    // 每個感測器所儲存的時間序列資料
    struct TemperatureSensor: Identifiable {
        var id: String
        var records: [Record]
    }
    
    var allSensors: [TemperatureSensor] = [
        .init(id: "車庫", records: [
            .init(publishTime: "2022-6-1 10:0:0", value: 23),
            .init(publishTime: "2022-6-1 11:0:0", value: 24),
            .init(publishTime: "2022-6-1 12:0:0", value: 26),
            .init(publishTime: "2022-6-1 13:0:0", value: 29),
            .init(publishTime: "2022-6-1 14:0:0", value: 28),
            .init(publishTime: "2022-6-1 15:0:0", value: 25),
        ]),
        .init(id: "花園", records: [
            .init(publishTime: "2022-6-1 10:0:0", value: 18),
            .init(publishTime: "2022-6-1 11:0:0", value: 19),
            .init(publishTime: "2022-6-1 12:0:0", value: 23),
            .init(publishTime: "2022-6-1 13:0:0", value: 17),
            .init(publishTime: "2022-6-1 14:0:0", value: 16),
            .init(publishTime: "2022-6-1 15:0:0", value: 14),
        ]),
    ]
    
    var body: some View {
        Chart(allSensors) { sensor in
            ForEach(sensor.records) { record in
                LineMark(
                    x: .value("Time", record.date, unit: .hour),
                    y: .value("Value", record.value)
                )
                .lineStyle(.init(lineWidth: 5))
            }
            .foregroundStyle(by: .value("Location", sensor.id))
            .symbol(by: .value("Sensor Location", sensor.id))
            .symbolSize(400)
        }
        .chartXAxis(.hidden)
        .chartYAxis(.hidden)

    }
}

struct CustomStyle_Previews: PreviewProvider {
    static var previews: some View {
        CustomStyle()
    }
}
