//
//  GanttChart.swift
//  ChartsDemo
//
//  Created by 朱克剛 on 2022/8/28.
//

import SwiftUI
import Charts

struct GanttChart: View {
    struct TaskItem: Identifiable {
        var id = UUID()
        var title: String
        var startTime: Int
        var endTime: Int
    }
    
    var tasks: [TaskItem] = [
        .init(title: "Task1", startTime: 1, endTime: 5),
        .init(title: "Task2", startTime: 7, endTime: 13),
        .init(title: "Task3", startTime: 10, endTime: 17),
        .init(title: "Task4", startTime: 5, endTime: 13),
        .init(title: "Task5", startTime: 18, endTime: 23),
        .init(title: "Task6", startTime: 3, endTime: 24),
        .init(title: "Task7", startTime: 20, endTime: 24)
    ]
    
    var body: some View {
        Chart(tasks) { item in
            BarMark(
                xStart: .value("Start", item.startTime),
                xEnd: .value("End", item.endTime),
                y: .value("Title", item.title),
                height: .ratio(0.4)
            )
        }
    }
}

struct GanttChart_Previews: PreviewProvider {
    static var previews: some View {
        GanttChart()
    }
}
