//
//  Gesture.swift
//  ChartsDemo
//
//  Created by 朱克剛 on 2022/8/28.
//

import SwiftUI
import Charts

struct Gesture: View {
    struct Product: Identifiable {
        var id = UUID()
        var name: String
        var count: Int
    }
    
    var products: [Product] = [
        .init(name: "A", count: 7),
        .init(name: "B", count: 10),
        .init(name: "C", count: 12),
        .init(name: "D", count: 15),
        .init(name: "E", count: 20),
        .init(name: "F", count: 23),
        .init(name: "G", count: 18),
        .init(name: "H", count: 17),
        .init(name: "I", count: 15),
        .init(name: "J", count: 11),
        .init(name: "K", count: 9)
    ]
    
    @State var thisBarName: String? = nil
    @State var thisBarValue = 0
    @State var isLeading = true
    var body: some View {
        Chart {
            ForEach(products) { item in
                BarMark(
                    x: .value("Name", item.name),
                    y: .value("Count", item.count)
                )
            }
            
            if let thisBarName {
                RuleMark(
                    x: .value("Focus", thisBarName)
                )
                .foregroundStyle(.red)
                .annotation(
                    alignment: isLeading ? .leading : .trailing,
                    spacing: -30
                ) {
                    Text(" Count: \(thisBarValue) ")
                }
            }
        }
        .chartOverlay { chartProxy in
            GeometryReader { geoProxy in
                Rectangle().fill(.clear).contentShape(Rectangle())
                    .gesture(DragGesture()
                        .onChanged { value in
                            let plotArea = geoProxy[chartProxy.plotAreaFrame]
                            let xPosition = value.location.x - plotArea.origin.x
                            for product in products {
                                // 判斷式1
                                if let range = chartProxy.positionRange(forX: product.name) {
                                    // 判斷式2
                                    if range.contains(xPosition) {
                                        // 變數 product 為目前手勢作用的那筆資料
                                        thisBarName = product.name
                                        thisBarValue = product.count
                                        // 判斷式3
                                        // 判斷手指點到的長條圖是否已超過x軸一半
                                        if range.lowerBound > plotArea.midX {
                                            isLeading = false
                                        } else {
                                            isLeading = true
                                        }
                                        
                                        break
                                    }
                                }
                            }
                        }
                        .onEnded { _ in
                            thisBarName = nil
                        }
                )
            }
        }
    }
}

struct Gesture_Previews: PreviewProvider {
    static var previews: some View {
        Gesture()
    }
}
