//
//  HeatMaps.swift
//  ChartsDemo
//
//  Created by 朱克剛 on 2022/8/28.
//

import SwiftUI
import Charts

struct HeatMaps: View {
    struct Visitors: Identifiable {
        var id = UUID()
        var day: String
        var hour: Int
        var number: Int
    }

    var weekdayData: [Visitors] = [
        .init(day: "sat", hour: 10, number: 90),
        .init(day: "sat", hour: 11, number: 108),
        .init(day: "sat", hour: 12, number: 110),
        .init(day: "sat", hour: 13, number: 102),
        
        .init(day: "sun", hour: 10, number: 120),
        .init(day: "sun", hour: 11, number: 139),
        .init(day: "sun", hour: 12, number: 180),
        .init(day: "sun", hour: 13, number: 130),
        
        .init(day: "mon", hour: 10, number: 80),
        .init(day: "mon", hour: 11, number: 85),
        .init(day: "mon", hour: 12, number: 70),
        .init(day: "mon", hour: 13, number: 89)
    ]
    
    private func maxNumber() -> Int {
        return weekdayData.max { $0.number < $1.number }!.number
    }
    
    var body: some View {
        Chart(weekdayData) { data in
            RectangleMark(
                x: .value("Weekday", data.day),
                y: .value("Hour", String(data.hour)),
                width: .ratio(1),
                height: .ratio(1)
            )
//            .foregroundStyle(by: .value("Number", data.number))
            .foregroundStyle(.orange.opacity(
                Double(data.number) / Double(maxNumber())
            ))
        }
        .chartYAxis {
            AxisMarks(preset: .extended)
        }
    }
}

struct HeatMaps_Previews: PreviewProvider {
    static var previews: some View {
        HeatMaps()
    }
}
