//
//  LineChart.swift
//  ChartsDemo
//
//  Created by 朱克剛 on 2022/8/28.
//

import SwiftUI
import Charts

struct LineChart: View {
    struct Record: Identifiable {
        var id = UUID()
        var x: Int
        var y: Int
    }

    var records: [Record] = [
        .init(x: 1, y: 20),
        .init(x: 2, y: 25),
        .init(x: 3, y: 33),
        .init(x: 4, y: 27),
        .init(x: 5, y: 36)
    ]
    
    var body: some View {
        Chart(records) { record in
            LineMark(
                x: .value("X", record.x),
                y: .value("Y", record.y)
            )
            .interpolationMethod(.cardinal)
        }
    }
}

struct LineChart_Previews: PreviewProvider {
    static var previews: some View {
        LineChart()
    }
}
