//
//  RectangleChart.swift
//  ChartsDemo
//
//  Created by 朱克剛 on 2022/8/28.
//

import SwiftUI
import Charts

struct RectangleChart: View {
    struct Weather: Identifiable {
        var id = UUID()
        var date: Date
        var lowTemp: Int
        var highTemp: Int
        
        init(year: Int, month: Int, lowTemp: Int, highTemp: Int) {
            self.date = Calendar.current.date(from: DateComponents(year: year, month: month, day: 1))!
            self.lowTemp = lowTemp
            self.highTemp = highTemp
        }
    }

    var weatherData: [Weather] = [
        .init(year: 2021, month: 1, lowTemp: 13, highTemp: 19),
        .init(year: 2021, month: 2, lowTemp: 14, highTemp: 20),
        .init(year: 2021, month: 3, lowTemp: 15, highTemp: 22),
        .init(year: 2021, month: 4, lowTemp: 19, highTemp: 26),
        .init(year: 2021, month: 5, lowTemp: 22, highTemp: 29),
        .init(year: 2021, month: 6, lowTemp: 25, highTemp: 32),
        .init(year: 2021, month: 7, lowTemp: 26, highTemp: 34),
        .init(year: 2021, month: 8, lowTemp: 26, highTemp: 33),
        .init(year: 2021, month: 9, lowTemp: 24, highTemp: 31),
        .init(year: 2021, month: 10, lowTemp: 22, highTemp: 27),
        .init(year: 2021, month: 11, lowTemp: 18, highTemp: 24),
        .init(year: 2021, month: 12, lowTemp: 15, highTemp: 21)
    ]
    
    var body: some View {
        Chart(weatherData) { w in
            RectangleMark(
                x: .value("Date", w.date, unit: .month),
                yStart: .value("Low Temperature", w.lowTemp),
                yEnd: .value("High Temperature", w.highTemp)
            )
            .foregroundStyle(.gray.opacity(0.4))
            
            LineMark(
                x: .value("Date", w.date, unit: .month),
                y: .value("Avg", (w.highTemp + w.lowTemp) / 2)
            )
            .interpolationMethod(.cardinal)
        }
    }
}

struct RectangleChart_Previews: PreviewProvider {
    static var previews: some View {
        RectangleChart()
    }
}
