//
//  StackedBarChart.swift
//  BarChart
//
//  Created by 朱克剛 on 2022/8/28.
//

import SwiftUI
import Charts

struct StackedBarChart: View {
    struct Product: Identifiable {
        var id = UUID()
        var name: String
        var count: Int
        var year: String
    }
    
    var products: [Product] = [
        .init(name: "鉛筆", count: 17, year: "2021"),
        .init(name: "橡皮擦", count: 8, year: "2021"),
        .init(name: "膠帶", count: 15, year: "2021"),
        
        .init(name: "鉛筆", count: 20, year: "2022"),
        .init(name: "橡皮擦", count: 13, year: "2022"),
        .init(name: "膠帶", count: 2, year: "2022"),
    ]
    
    var body: some View {
        Chart(products) { item in
            BarMark(
                x: .value("名稱", item.name),
                y: .value("銷售量", item.count)
            )
            .foregroundStyle(by: .value("Color", item.year))
            .annotation(position: .overlay) {
                Text(item.count, format: .number)
            }
        }
        .chartForegroundStyleScale([
            "2021": .mint,
            "2022": .yellow
        ])
    }
}

struct StackedBarChart_Previews: PreviewProvider {
    static var previews: some View {
        StackedBarChart()
    }
}
