//
//  CurvePath.swift
//  AnimationAndGraph
//
//  Created by 朱克剛 on 2022/8/29.
//

import SwiftUI

struct CurvePath: View {
    var body: some View {
        let slope: CGFloat = (200 - 400) / (150 - 40)
        Path { path in
            path.move(to: CGPoint(x: 10, y: 200))
            // 二次貝茲曲線
            path.addQuadCurve(
                to: CGPoint(x: 150, y: 200),
                control: CGPoint(x:40,y:400)
            )
            // 三次貝茲曲線
            path.addCurve(
                to: CGPoint(x: 350, y: 200),
                control1: CGPoint(x: 200, y: slope * (200 - 150) + 200),
                control2: CGPoint(x: 250, y: 350)
            )
            // 接點處
            path.addEllipse(in:
                CGRect(x: 130, y: 180, width: 40, height: 40)
            )
        }
        .stroke(lineWidth: 10)
    }
}

struct CurvePath_Previews: PreviewProvider {
    static var previews: some View {
        CurvePath()
    }
}
