//
//  GradientCircleProgress.swift
//  AnimationAndGraph
//
//  Created by 朱克剛 on 2022/8/29.
//

import SwiftUI

struct MyCircle: Shape {
    @State var angle = Angle(degrees: 45)
    
    func path(in rect: CGRect) -> Path {
        Path { path in
            path.addArc(
                center: CGPoint(x: rect.midX, y: rect.midY),
                radius: rect.width / 2.0,
                startAngle: Angle(degrees: 135),
                endAngle: angle,
                clockwise: false
            )
        }
    }
}


struct GradientCircleProgress: View {
    private let style = StrokeStyle(lineWidth: 20, lineCap: .round)
    private let gradient = AngularGradient(
            colors: [.green, .orange, .red, .purple],
            center: .center,
            startAngle: .degrees(135),
            endAngle: .degrees(405)
//            angle: .degrees(90)
        )
    @State private var trimValue = 0.0

    var body: some View {
        MyCircle()
            .stroke(.gray.opacity(0.2), style: style)
            .frame(width: 200, height: 200)
            .overlay {
                MyCircle(angle: .degrees(350))
                    .trim(to: trimValue)
                    .stroke(gradient, style: style)
                    .animation(.easeOut, value: trimValue)
                    .onAppear {
                        trimValue = 1.0
                    }
            }
            .overlay {
                Text("Air Pollution").font(.title)
            }
            .overlay {
                MyCircle()
                    .stroke(.black, style: .init(lineWidth: 10, dash: [1, 30]))
            }
    }
}

struct GradientCircleProgress_Previews: PreviewProvider {
    static var previews: some View {
        GradientCircleProgress()
    }
}
