//
//  LineAnimation.swift
//  AnimationAndGraph
//
//  Created by 朱克剛 on 2022/8/29.
//

import SwiftUI

struct MyLine: Shape {
    var start: CGPoint = .zero
    var end: CGPoint = .zero
    
    var animatableData: AnimatablePair<CGPoint.AnimatableData, CGPoint.AnimatableData> {
           get {
               AnimatablePair(start.animatableData, end.animatableData)
           }
           set {
               start.animatableData = newValue.first
               end.animatableData = newValue.second
           }
       }
    
    func path(in rect: CGRect) -> Path {
        Path { path in
            path.move(to: start)
            path.addLine(to: end)
        }
    }
}


struct LineAnimation: View {
    @State private var start = CGPoint.zero
    @State private var end = CGPoint(x: 100, y: 100)
    
    var body: some View {
        MyLine(start: start, end: end)
            .stroke(.black, lineWidth: 10)
            .frame(width: 200, height: 200)
            .onTapGesture {
                withAnimation {
                    start = .init(x: 170, y: 30)
                    end = .init(x: 30, y: 180)
                }
            }
    }
}

struct LineAnimation_Previews: PreviewProvider {
    static var previews: some View {
        LineAnimation()
    }
}
