//
//  Rotation.swift
//  AnimationAndGraph
//
//  Created by 朱克剛 on 2022/8/28.
//

import SwiftUI

struct Rotation: View {
    @State private var angle = Angle(degrees: 0)
    @State private var scale = 1.0
    @State private var opacity = 0.2
    
    var body: some View {
        Image(systemName: "chevron.right.circle")
            .imageScale(.large)
            .rotationEffect(angle)
            .scaleEffect(scale)
            .foregroundColor(.blue.opacity(opacity))
            .animation(.default, value: angle)
            .onTapGesture {
                angle += .degrees(90)
                scale = (scale == 1.0) ? 2.0 : 1.0
                opacity = (opacity == 1.0) ? 0.2 : 1.0
            }
    }
}

struct Rotation_Previews: PreviewProvider {
    static var previews: some View {
        Rotation()
    }
}
